;Copyright (C) 2004-2012 John T. Haller of PortableApps.com

;Website: http://portableapps.com/SumatraPDFPortable

;This software is OSI Certified Open Source Software.
;OSI Certified is a certification mark of the Open Source Initiative.

;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.

;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

!define PORTABLEAPPNAME "Sumatra PDF Portable"
!define APPNAME "SumatraPDF"
!define NAME "SumatraPDFPortable"
!define VER "1.6.8.0"
!define WEBSITE "PortableApps.com/SumatraPDFPortable"
!define DEFAULTEXE "SumatraPDF.exe"
!define DEFAULTAPPDIR "SumatraPDF"
!define LAUNCHERLANGUAGE "English"

;=== Program Details
Name "${PORTABLEAPPNAME}"
OutFile "..\..\${NAME}.exe"
Caption "${PORTABLEAPPNAME} | PortableApps.com"
VIProductVersion "${VER}"
VIAddVersionKey ProductName "${PORTABLEAPPNAME}"
VIAddVersionKey Comments "Allows ${APPNAME} to be run from a removable drive.  For additional details, visit ${WEBSITE}"
VIAddVersionKey CompanyName "PortableApps.com"
VIAddVersionKey LegalCopyright "John T. Haller"
VIAddVersionKey FileDescription "${PORTABLEAPPNAME}"
VIAddVersionKey FileVersion "${VER}"
VIAddVersionKey ProductVersion "${VER}"
VIAddVersionKey InternalName "${PORTABLEAPPNAME}"
VIAddVersionKey LegalTrademarks "PortableApps.com is a Trademark of Rare Ideas, LLC."
VIAddVersionKey OriginalFilename "${NAME}.exe"
;VIAddVersionKey PrivateBuild ""
;VIAddVersionKey SpecialBuild ""

;=== Runtime Switches
CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True
RequestExecutionLevel user
XPStyle on

; Best Compression
SetCompress Auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize On

;=== Include
;(Standard NSIS)
!include FileFunc.nsh
!insertmacro GetParameters
!insertmacro GetParent
!insertmacro GetRoot
!include LogicLib.nsh

;(NSIS Plugins)
!include TextReplace.nsh

;(Custom)
!include CheckForPlatformSplashDisable.nsh
!include ReplaceInFileWithTextReplace.nsh
!include ReadINIStrWithDefault.nsh

;=== Program Icon
Icon "..\..\App\AppInfo\appicon.ico"

;=== Icon & Stye ===
;!define MUI_ICON "..\..\App\AppInfo\appicon.ico"

;=== Languages
;!insertmacro MUI_LANGUAGE "${LAUNCHERLANGUAGE}"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\${LAUNCHERLANGUAGE}.nlf"
!include PortableApps.comLauncherLANG_${LAUNCHERLANGUAGE}.nsh

Var PROGRAMDIRECTORY
Var SETTINGSDIRECTORY
Var ADDITIONALPARAMETERS
Var EXECSTRING
Var PROGRAMEXECUTABLE
Var SECONDARYLAUNCH
Var DISABLESPLASHSCREEN
Var LASTDRIVE
Var CURRENTDRIVE
Var MISSINGFILEORPATH
Var strLastPortableAppsRoot
Var strPortableAppsRoot

Section "Main"
	;=== Check if already running
	System::Call 'kernel32::CreateMutexW(i 0, i 0, t "${NAME}") i .r1 ?e'
	Pop $0
	StrCmp $0 0 CheckINI
		StrCpy $SECONDARYLAUNCH "true"

	CheckINI:
		;=== Find the INI file, if there is one
		IfFileExists "$EXEDIR\${NAME}.ini" "" NoINI
			;=== Read the parameters from the INI file
			${ReadINIStrWithDefault} $ADDITIONALPARAMETERS "$EXEDIR\${NAME}.ini" "${NAME}" "AdditionalParameters" ""
			${ReadINIStrWithDefault} $DISABLESPLASHSCREEN "$EXEDIR\${NAME}.ini" "${NAME}" "DisableSplashScreen" "false"
			StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\App\${DEFAULTAPPDIR}"
			StrCpy "$SETTINGSDIRECTORY" "$EXEDIR\Data\settings"
			Goto EndINI

	NoINI:
		;=== No INI file, so we'll use the defaults
		StrCpy "$ADDITIONALPARAMETERS" ""
		StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"

		IfFileExists "$EXEDIR\App\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" NoProgramEXE
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\App\${DEFAULTAPPDIR}"
			StrCpy "$SETTINGSDIRECTORY" "$EXEDIR\Data\settings"
			GoTo EndINI

	EndINI:
		IfFileExists "$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" FoundProgramEXE

	NoProgramEXE:
		;=== Program executable not where expected
		StrCpy $MISSINGFILEORPATH $PROGRAMEXECUTABLE
		MessageBox MB_OK|MB_ICONEXCLAMATION `$(LauncherFileNotFound)`
		Abort
		
	FoundProgramEXE:
		;=== Check if running
		StrCmp $SECONDARYLAUNCH "true" GetPassedParameters
		FindProcDLL::FindProc "${DEFAULTEXE}"
		StrCmp $R0 "1" WarnAnotherInstance DisplaySplash

	WarnAnotherInstance:
		MessageBox MB_OK|MB_ICONINFORMATION `$(LauncherAlreadyRunning)`
		Abort
	
	DisplaySplash:
		${CheckForPlatformSplashDisable} $DISABLESPLASHSCREEN
		StrCmp $DISABLESPLASHSCREEN "true" GetPassedParameters
			;=== Show the splash screen while processing registry entries
			InitPluginsDir
			File /oname=$PLUGINSDIR\splash.jpg "${NAME}.jpg"
			newadvsplash::show /NOUNLOAD 1200 0 0 -1 /L $PLUGINSDIR\splash.jpg
	
	GetPassedParameters:
		;=== Get any passed parameters
		${GetParameters} $0
		StrCmp "'$0'" "''" "" LaunchProgramParameters

		;=== No parameters
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE"`
		Goto AdditionalParameters

	LaunchProgramParameters:
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" $0`

	AdditionalParameters:
		StrCmp $ADDITIONALPARAMETERS "" SettingsDirectory

		;=== Additional Parameters
		StrCpy $EXECSTRING `$EXECSTRING $ADDITIONALPARAMETERS`
	
	SettingsDirectory:
		;=== Set the settings directory if we have a path
		IfFileExists "$SETTINGSDIRECTORY\*.*" CheckForSettings
			CreateDirectory $SETTINGSDIRECTORY
			CopyFiles /SILENT `$EXEDIR\App\DefaultData\settings\*.*` $SETTINGSDIRECTORY
	
	CheckForSettings:
		StrCmp $SECONDARYLAUNCH "true" LaunchAndExit
		IfFileExists "$PROGRAMDIRECTORY\sumatrapdfprefs.dat" AdjustPaths
		IfFileExists "$SETTINGSDIRECTORY\sumatrapdfprefs.dat" MoveSettings AdjustPaths
		;IfFileExists "$EXEDIR\App\DefaultData\sumatrapdfprefs.dat" "" LaunchNow
		;	CopyFiles /SILENT "$EXEDIR\App\DefaultData\sumatrapdfprefs.dat" "$PROGRAMDIRECTORY"
		;	Goto LaunchNow

	MoveSettings:
		Rename "$SETTINGSDIRECTORY\sumatrapdfprefs.dat" "$PROGRAMDIRECTORY\sumatrapdfprefs.dat"
		Rename "$SETTINGSDIRECTORY\sumatrapdfcache" "$PROGRAMDIRECTORY\sumatrapdfcache"
		
	AdjustPaths:
		${GetRoot} $EXEDIR $CURRENTDRIVE
		${ReadINIStrWithDefault} $LASTDRIVE "$SETTINGSDIRECTORY\${NAME}Settings.ini" "${NAME}Settings" "LastDrive" $CURRENTDRIVE
		${GetParent} $EXEDIR $strPortableAppsRoot
		${GetParent} $strPortableAppsRoot $strPortableAppsRoot
		${If} $strPortableAppsRoot == ""
			StrCpy $strPortableAppsRoot "$CURRENTDRIVE\"
		${EndIf}
		${ReadINIStrWithDefault} $strLastPortableAppsRoot "$SETTINGSDIRECTORY\${NAME}Settings.ini" "${NAME}Settings" "LastPortableAppsRoot" $strPortableAppsRoot
		IfFileExists "$PROGRAMDIRECTORY\sumatrapdfprefs.dat" "" RememberPath
			${ReplaceInFile} "$PROGRAMDIRECTORY\sumatrapdfprefs.dat" ':$LASTDRIVE\' ':$CURRENTDRIVE\'
			${ReplaceInFile} "$PROGRAMDIRECTORY\sumatrapdfprefs.dat" ':$strLastPortableAppsRoot\' ':$strPortableAppsRoot\'

	RememberPath:
		WriteINIStr "$SETTINGSDIRECTORY\${NAME}Settings.ini" "${NAME}Settings" "LastDrive" "$CURRENTDRIVE"
		WriteINIStr "$SETTINGSDIRECTORY\${NAME}Settings.ini" "${NAME}Settings" "LastPortableAppsRoot" "$strPortableAppsRoot"
		
	;GetCurrentLanguage
		${ReadINIStrWithDefault} $0 "$SETTINGSDIRECTORY\${NAME}Settings.ini" "${NAME}Settings" "LastLanguage" "en"
		ReadEnvStr $1 "PortableApps.comLocaleCode2"
		StrCmp $1 "" LaunchNow ;If no env var, skip it
		StrCmp $0 $1 LaunchNow ;If the same, skip it
			${ReplaceInFile} "$PROGRAMDIRECTORY\sumatrapdfprefs.dat" 'UILanguage2:$0' 'UILanguage2:$1'
			WriteINIStr "$SETTINGSDIRECTORY\${NAME}Settings.ini" "${NAME}Settings" "LastLanguage" "$1"

	LaunchNow:
		ExecWait $EXECSTRING
		
	CheckRunning:
		Sleep 1000
		FindProcDLL::FindProc "${DEFAULTEXE}"                  
		StrCmp $R0 "1" CheckRunning

	;=== Put the settings file back
	Sleep 500
	Rename "$PROGRAMDIRECTORY\sumatrapdfprefs.dat" "$SETTINGSDIRECTORY\sumatrapdfprefs.dat"
	Rename "$PROGRAMDIRECTORY\sumatrapdfcache" "$SETTINGSDIRECTORY\sumatrapdfcache"
	Goto TheEnd
	
	LaunchAndExit:
		Exec $EXECSTRING

	TheEnd:
		newadvsplash::stop /WAIT
SectionEnd