@echo off
:: --------------------------------------------------------------------------------------------------------------------------
:: TR3Secure Volatile Data Collection Kit
::
:: v1.0
::
:: tr3-collect is a batch script to automate the collection of volatile data and select artifacts from live Windows systems
::
:: Change history
::
:: References
::
:: Malware Forensics: Investigating and Analyzing Malicious Code by Cameron H. Malin, Eoghan Casey, and James M. Aquilina 
:: Windows Forensics Analysis (WFA) Second Edition by Harlan Carvey
:: RFC 3227 - Guidelines for Evidence Collection and Archiving http://www.faqs.org/rfcs/rfc3227.html
::
:: Copyright 2011 Corey Harrell (http://journeyintoir.blogspot.com)
:: 
:: --------------------------------------------------------------------------------------------------------------------------
:: Declare and Set Variables
:: --------------------------------------------------------------------------------------------------------------------------
:: This section configures the variables used thoughout the script
::
:: Declaring all variables for the script and setting them as null
set case=""
set examiner=""
set t_drive=""
set c_drive=""


set selection=""
set goback=n
set m=""
set d=""
set y=""
set hh=""
set mm=""
set timestamp=""
set mem_outpath=""
set vol_outpath=""
set nonvol_outpath=""
::
:: Populates the case identifier and analysts name variables
set /p case=Enter the identifier for the case:   
echo:
set /p examiner=Enter the examiner's name(i.e. John Doe):   
:: Populates the drive letter variable
cls
echo %DATE% %TIME% - Running %WINDIR%\System32\diskpart.exe on %COMPUTERNAME% 
echo:
diskpart.exe /s tools\diskpart_commands.txt
echo:
echo:
set /p t_drive=Enter the drive letter for the volume storing the tools (i.e. F):   
echo:
set /p c_drive=Enter the drive letter for the volume to store the collection data (i.e. G):   
:: --------------------------------------------------------------------------------------------------------------------------
:: Create Log
:: --------------------------------------------------------------------------------------------------------------------------
:: This section sets up the logging function of the script
::
cls
:: Creates the directory on the collection drive to store data if it isn't already present
if not exist %c_drive%:\Data-%case% (
	echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create the case output folder Data-%case%
	echo:
	tools\mkdir.exe %c_drive%:\Data-%case%
	)
:: Will create the log file if it's not present and start logging 
if not exist %c_drive%:\Data-%case%\Collection.log (
	echo ****************************************************************************************** > %c_drive%:\Data-%case%\Collection.log
	echo Collection Log for Case %case% >> %c_drive%:\Data-%case%\Collection.log
	echo ****************************************************************************************** >> %c_drive%:\Data-%case%\Collection.log
	echo Log Created at %DATE% %TIME% >> %c_drive%:\Data-%case%\Collection.log
	echo: >> %c_drive%:\Data-%case%\Collection.log
	echo: >> %c_drive%:\Data-%case%\Collection.log
	)
echo ------------------------------------------------------------------------------------------ >> %c_drive%:\Data-%case%\Collection.log
echo %DATE% %TIME% - Logging initiated for %COMPUTERNAME% >> %c_drive%:\Data-%case%\Collection.log
echo %DATE% %TIME% - Logging initiated for %COMPUTERNAME%
echo %DATE% %TIME% - Logging started on %COMPUTERNAME% by %examiner% using account %USERDOMAIN%\%USERNAME%  >> %c_drive%:\Data-%case%\Collection.log
echo %DATE% %TIME% - The drive letter for the volume storing the tools is %t_drive%: >> %c_drive%:\Data-%case%\Collection.log
echo %DATE% %TIME% - The drive letter for the volume storing the collection data is %c_drive%: >> %c_drive%:\Data-%case%\Collection.log
echo:
pause
cls
:: Documents the time skew by comparing the system time to a known good time
echo Documenting computer %COMPUTERNAME% date/time compared to a known good time
echo:
echo:
set /p current_date=Enter the current date in two digit month, two digit day, and four digit year (i.e. 01/01/2011):   
:: batch scripting doesn't have a way to store a command's output into a variable which is why a for loop is needed
FOR /F "tokens=*" %%i in ('date /t') do set _date=%%i 
echo %DATE% %TIME% - The computer %COMPUTERNAME% configured date is %_date% while the know date is %current_date% >> %c_drive%:\Data-%case%\Collection.log
echo:
set /p current_time=Enter the current time in 12 hour clock format (i.e. 09:00 AM):    
:: batch scripting doesn't have a way to store a command's output into a variable which is why a for loop is needed
FOR /F "tokens=*" %%i in ('time /t') do set _time=%%i 
echo %DATE% %TIME% - The computer %COMPUTERNAME% configured time is %_time% while the know time is %current_time% >> %c_drive%:\Data-%case%\Collection.log
cls
:: --------------------------------------------------------------------------------------------------------------------------
:: Main Menu
:: --------------------------------------------------------------------------------------------------------------------------
:: This section lays out the functionality provided by the script
::
:menu
	echo tr3-collect Main Menu Options
	echo:
	echo:
	echo Press 1 to Acquire Memory Forensic Image Only
	echo Press 2 to Acquire Volatile Data Information Only
	echo Press 3 to Acquire Memory Forensic Image and Volatile Data Information
	echo Press 4 to Acquire Memory Forensic Image, Volatile Data Information, and Non-Volatile Data Information
	echo Press 5 to exit
	echo:
	set /p selection=Enter your selection:  
	cls
	:: if statement below is warning that only collecting the memory will result in losing some prefetch files
	:: provides an option to make another selection
	if %selection% == 1 (
		echo Prefetch files are not collected with the Acquire Memory Forensic Image Only option.
		echo:
		:: Prefetch files will be overwritten when the programs to acquire memory are executed
		echo This may result in overwriting some information about the programs that executed on computer %COMPUTERNAME%
		echo: 
		set /p goback=Do you wish to continue with your current selection [y/N]?  
		cls
		:: Goes back to the menu for another option to be selected
		if %goback% == n goto :menu
		)
	:: Logs the selection made
	if %selection% == 1 echo %DATE% %TIME% - Selection was made to acquire memory forensic image only for %COMPUTERNAME% >> %c_drive%:\Data-%case%\Collection.log
	if %selection% == 2 echo %DATE% %TIME% - Selection was made to acquire volatile data information only for %COMPUTERNAME% >> %c_drive%:\Data-%case%\Collection.log
	if %selection% == 3 echo %DATE% %TIME% - Selection was made to acquire memory forensic image and volatile data information for %COMPUTERNAME% >> %c_drive%:\Data-%case%\Collection.log
	if %selection% == 4 echo %DATE% %TIME% - Selection was made to acquire memory forensic image, volatile data information, and non-volatile data information for %COMPUTERNAME% >> %c_drive%:\Data-%case%\Collection.log
	if %selection% == 5 echo %DATE% %TIME% - Selection was made to exit the collection script for %COMPUTERNAME% >> %c_drive%:\Data-%case%\Collection.log
	if %selection% == 5 goto :exit
	goto :main
:: --------------------------------------------------------------------------------------------------------------------------
:: Main Processing Area
:: --------------------------------------------------------------------------------------------------------------------------
:: This section performs the data collection from the system
::
:main
	:: The main function creates the output folder and preserves the computer's prefetch files to prevent them from being overwriten 
	::
	:: The collection output folder's name is based on the computer's name and the timestamp of when the data was collected
	:: 
	:: Setting up a timestamp variable because %date% and %time% variables contain characters that cannot be used in folder names
	:: Below sets up variables for the date by getting the month, day, and year in two digits
	set m=%date:~4,2%
	set d=%date:~7,2%
	set y=%date:~12,2%
	:: Below sets up variables for the time by getting the hour and minute in two digits
	set hh=%time:~0,2%
	set mm=%time:~3,2%
	:: Creates the date/time variable for naming folders
	set timestamp=%m%.%d%.%y%-%hh%.%mm%
	:: Creating directory for output data. The naming convention allows the script to be 
	:: executed numerous times without overwriting previous output data
	if not exist %c_drive%:\Data-%case%\%computername%-%timestamp% (
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create the output directory %computername%-%timestamp%
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create the output directory %computername%-%timestamp% >> %c_drive%:\Data-%case%\Collection.log
		tools\mkdir.exe %c_drive%:\Data-%case%\%computername%-%timestamp%
		)
	:: Acquire Memory Forensic Image Only option does not preserve the prefetch files 
	if %selection% == 1 goto :acquire_memory
	:: Creates directory to store preserved prefetch files
	echo %DATE% %TIME% - Running tools\mkdir.exe -p on %COMPUTERNAME% to create directories to store preserved Prefetch files
	echo %DATE% %TIME% - Running tools\mkdir.exe -p on %COMPUTERNAME% to create directories to store preserved Prefetch files >> %c_drive%:\Data-%case%\Collection.log
	tools\mkdir.exe -p %c_drive%:\Data-%case%\%computername%-%timestamp%\preserved-prefetch-files\Prefetch
	:: Robocopy preserves the prefetch files including the filesystem metadata
	echo %DATE% %TIME% - Running tools\robocopy.exe on %COMPUTERNAME% to preserve prefetch files
	echo %DATE% %TIME% - Running tools\robocopy.exe on %COMPUTERNAME% to preserve prefetch files >> %c_drive%:\Data-%case%\Collection.log
	:: The following are the robocopy swithes: /zb  Tries to copy files in restartable mode, 
	::  /copy:DATSOU copy file data attributes, timestamps, ntfs permissions, file ownership, file auditing, /r:3  retry 3 times,
	:: /W:3 wait 1 seconds between retries, /ts source timestamps in log, /FP displays full pathnames in output,
	:: /np progress indicator turned off and /log  creates log file by overwriting one if already exists
	tools\robocopy.exe %WINDIR%\Prefetch %c_drive%:\Data-%case%\%computername%-%timestamp%\preserved-prefetch-files\Prefetch\ /ZB /copy:DTSOU /r:4 /w:1 /ts /FP /np /log:%c_drive%:\Data-%case%\%computername%-%timestamp%\preserved-prefetch-files\pretch-robocopy-log.txt)
	:: Calls the option selected
	if %selection% == 2 goto :acquire_volatile
	if %selection% == 3 goto :acquire_memory
	if %selection% == 4 goto :acquire_memory
:acquire_memory
	:: The acquire_memory function forensicly images the computer's memory.
	:: The script uses Mandiant's Memoryze but can be modified to uses any memory image program of choice
	:: Just comment out all the lines related to Memoryze
	::
	:: Creating output folder for the memory image
	if not exist %c_drive%:\Data-%case%\%computername%-%timestamp%\memory-image (
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the memory image
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the memory image >> %c_drive%:\Data-%case%\Collection.log
		tools\mkdir.exe %c_drive%:\Data-%case%\%computername%-%timestamp%\memory-image
		)
	:: Creating a variable to the memory-image directory to shorten the code
	set mem_outpath=%c_drive%:\Data-%case%\%computername%-%timestamp%\memory-image
	:: Writing the XML file that Memoryze uses to dump the memory
	echo %DATE% %TIME% - Creating the Memoryze config file on the collection volume %c_drive%:
	echo %DATE% %TIME% - Creating the Memoryze config file on the collection volume %c_drive%: >> %c_drive%:\Data-%case%\Collection.log
	:: The following code was obtained from the MemoryDD.bat included with Mandiant's Memoryze
	:: Please note: the only code used from MemoryDD.bat were the commands to build the xml file
	echo ^<?xml version=^"1.0^" encoding=^"utf-8^"?^> > %mem_outpath%\config.txt
	echo ^<script xmlns:xsi=^"http://www.w3.org/2001/XMLSchema-instance^" xmlns:xsd=^"http://www.w3.org/2001/XMLSchema^" chaining=^"implicit^"^> >> %mem_outpath%\config.txt
	echo  ^<commands^> >> %mem_outpath%\config.txt
	echo    ^<command xsi:type=^"ExecuteModuleCommand^"^> >> %mem_outpath%\config.txt
	echo      ^<module name=^"w32memory-acquisition^" version=^"1.3.22.2^" /^> >> %mem_outpath%\config.txt
	echo      ^<config xsi:type=^"ParameterListModuleConfig^"^> >> %mem_outpath%\config.txt
	echo        ^<parameters^> >> %mem_outpath%\config.txt 
	echo        ^</parameters^> >> %mem_outpath%\config.txt
	echo      ^</config^> >> %mem_outpath%\config.txt
	echo    ^</command^> >> %mem_outpath%\config.txt
	echo  ^</commands^> >> %mem_outpath%\config.txt
	echo ^</script^> >> %mem_outpath%\config.txt
	:: Obtaining forensic image of the memory
	echo %DATE% %TIME% - Running tools\Memoryze.exe on %COMPUTERNAME% to aquire the memory image
	echo %DATE% %TIME% - Running tools\Memoryze.exe on %COMPUTERNAME% to aquire the memory image >> %c_drive%:\Data-%case%\Collection.log
	START /WAIT tools\Memoryze.exe -o %mem_outpath%\ -script %mem_outpath%\config.txt -encoding none -allowmultiple
	echo:
	echo %DATE% %TIME% - Imaging completed for acquring %COMPUTERNAME%'s memory
	echo %DATE% %TIME% - Imaging completed for acquring %COMPUTERNAME%'s memory >> %c_drive%:\Data-%case%\Collection.log
	echo:
	:: Exiting the acquire_memory function
	if %selection% == 3 goto :acquire_volatile
	if %selection% == 4 goto :acquire_volatile
	pause
	cls
	goto :menu
:acquire_volatile
	:: The acquire_volatile function obtains volatile data from the system
	:: RFC 3227's section Order of Volatilty was taken into consideration when specifying the sequence of the data collection
	::
	:: For additional information about the tools used or why the tools' output is important then 
	:: read the comments in this batch file since I noted the exact page numbers 
	:: in my references where the information is covered
	::
	:: The naming convention for the output files is as follows: TypeInfo_#_data-name
		:: The TypeInfo specifies the collected information such as NetworkInfo
		:: The number is the order that the file could be reviewed. For those with a different prefence just ignore the numbers
		:: The data name is the volatile data that was collected such as active-connections
	:: Creating output directory
	if not exist %c_drive%:\Data-%case%\%computername%-%timestamp%\volatile-data (
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the volatile data
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the volatile data >> %c_drive%:\Data-%case%\Collection.log
		tools\mkdir.exe %c_drive%:\Data-%case%\%computername%-%timestamp%\volatile-data
		)
	:: Creating a variable to the volatile-data directory to shorten the code
	set vol_outpath=%c_drive%:\Data-%case%\%computername%-%timestamp%\volatile-data
	:: Collecting process information
		echo %DATE% %TIME% - Collecting process information from %COMPUTERNAME% volatile data
		echo %DATE% %TIME% - Collecting process information from %COMPUTERNAME% volatile data >> %c_drive%:\Data-%case%\Collection.log
		:: Listing the running processes
		:: pslist.exe reference: Malware Forensics page 35 or WFA page 26
			echo Command Executed: pslist.exe /accepteula > %vol_outpath%\ProcessInfo_1_running-processes.txt
			echo: >> %vol_outpath%\ProcessInfo_1_running-processes.txt
			echo %DATE% %TIME% - Running tools\pslist.exe /accepteula on %COMPUTERNAME% to obtain the running processes
			echo %DATE% %TIME% - Running tools\pslist.exe /accepteula on %COMPUTERNAME% to obtain the running processes >> %c_drive%:\Data-%case%\Collection.log
			tools\pslist.exe /accepteula >> %vol_outpath%\ProcessInfo_1_running-processes.txt
		:: Listing the running processes including memory usage
		:: tasklist.exe reference: Malware Forensics page 36 and WFA page 26
			echo Command Executed: tasklist.exe > %vol_outpath%\ProcessInfo_1_running-processes-memory-usage.txt
			echo: >> %vol_outpath%\ProcessInfo_1_running-processes-memory-usage.txt
			echo %DATE% %TIME% - Running %WINDIR%\System32\tasklist.exe on %COMPUTERNAME% to obtain the running processes including memory usage
			echo %DATE% %TIME% - Running %WINDIR%\System32\tasklist.exe on %COMPUTERNAME% to obtain the running processes including memory usage >> %c_drive%:\Data-%case%\Collection.log	
			%WINDIR%\System32\tasklist.exe >> %vol_outpath%\ProcessInfo_1_running-processes-memory-usage.txt
		:: Listing the processes to exe mapping
		:: pv.exe -e reference: Malware Forensics page 37
			echo Command Executed: pv.exe -e > %vol_outpath%\ProcessInfo_2_process-to-exe-mapping.txt
			echo: >> %vol_outpath%\ProcessInfo_2_process-to-exe-mapping.txt
			echo %DATE% %TIME% - Running tools\pv.exe -e on %COMPUTERNAME% to obtain the processes to exe mapping
			echo %DATE% %TIME% - Running tools\pv.exe -e on %COMPUTERNAME% to obtain the processes to exe mapping >> %c_drive%:\Data-%case%\Collection.log	
			tools\pvc.exe -e >> %vol_outpath%\ProcessInfo_2_process-to-exe-mapping.txt
		:: Listing the processes to user mapping
		:: currprocess.exe /stext reference: Malware Forensics page 38
			echo %DATE% %TIME% - Running tools\currprocess.exe /stext on %COMPUTERNAME% to obtain the processes to user mapping
			echo %DATE% %TIME% - Running tools\currprocess.exe /stext on %COMPUTERNAME% to obtain the processes to user mapping >> %c_drive%:\Data-%case%\Collection.log	
			tools\currprocess.exe /stext %vol_outpath%\ProcessInfo_3_process-to-user-mapping.txt
		:: Listing the processes to user mapping in tab-delimited text file
		:: currprocess.exe /stab reference: Malware Forensics page 38
			echo %DATE% %TIME% - Running tools\currprocess.exe /stab on %COMPUTERNAME% to obtain the processes to user mapping in tab-delimited text file
			echo %DATE% %TIME% - Running tools\currprocess.exe /stab on %COMPUTERNAME% to obtain the processes to user mapping in tab-delimited text file >> %c_drive%:\Data-%case%\Collection.log	
			tools\currprocess.exe /stab %vol_outpath%\ProcessInfo_3_process-to-user-mapping_tab.csv
		:: Listing the child processes
		:: pslist.exe -t reference: Malware Forensics page 40 or WFA page 26
			echo Command Executed: pslist.exe -t /accepteula > %vol_outpath%\ProcessInfo_4_child-processes.txt
			echo: >> %vol_outpath%\ProcessInfo_4_child-processes.txt
			echo %DATE% %TIME% - Running %WINDIR%\System32\pslist.exe -t /accepteula on %COMPUTERNAME% to obtain the child processes
			echo %DATE% %TIME% - Running %WINDIR%\System32\pslist.exe -t /accepteula on %COMPUTERNAME% to obtain the child processes >> %c_drive%:\Data-%case%\Collection.log
			tools\pslist.exe -t /accepteula >> %vol_outpath%\ProcessInfo_4_child-processes.txt
		:: Listing the processes' file handles
		:: handle.exe reference: Malware Forensics page 42 or WFA page 27
			echo Command Executed: handle.exe /accepteula > %vol_outpath%\ProcessInfo_5_processe-file-handles.txt
			echo: >> %vol_outpath%\ProcessInfo_5_processe-file-handles.txt
			echo %DATE% %TIME% - Running tools\handle.exe /accepteula on %COMPUTERNAME% to obtain the processes' file handles
			echo %DATE% %TIME% - Running tools\handle.exe /accepteula on %COMPUTERNAME% to obtain the processes' file handles >> %c_drive%:\Data-%case%\Collection.log
			tools\handle.exe /accepteula >> %vol_outpath%\ProcessInfo_5_processe-file-handles.txt
		:: Listing the processes' dependencies
		:: listdlls.exe reference: Malware Forensics page 44 or WFA page 26
			echo Command Executed: listdlls.exe /accepteula > %vol_outpath%\ProcessInfo_6_processe-dependencies.txt
			echo: >> %vol_outpath%\ProcessInfo_6_processe-dependencies.txt
			echo %DATE% %TIME% - Running tools\listdlls.exe /accepteula on %COMPUTERNAME% to obtain the processes' dependencies
			echo %DATE% %TIME% - Running tools\listdlls.exe /accepteula on %COMPUTERNAME% to obtain the processes' dependencies >> %c_drive%:\Data-%case%\Collection.log
			tools\listdlls.exe /accepteula >> %vol_outpath%\ProcessInfo_6_processe-dependencies.txt
	:: Collecting network information
		echo %DATE% %TIME% - Collecting network information from %COMPUTERNAME% volatile data
		echo %DATE% %TIME% - Collecting network information from %COMPUTERNAME% volatile data >> %c_drive%:\Data-%case%\Collection.log
		:: Listing the active network connection
		:: netstat.exe -ano reference: Malware Forensics page 26 or WFA page 21
			echo Command Executed: netstat.exe -ano > %vol_outpath%\NetworkInfo_1_active-connections.txt
			echo: >> %vol_outpath%\NetworkInfo_1_active-connections.txt
			echo %DATE% %TIME% - Running %WINDIR%\System32\netstat.exe -ano on %COMPUTERNAME% to obtain the active network connections
			echo %DATE% %TIME% - Running %WINDIR%\System32\netstat.exe -ano on %COMPUTERNAME% to obtain the active network connections >> %c_drive%:\Data-%case%\Collection.log
			%WINDIR%\System32\netstat.exe -ano >> %vol_outpath%\NetworkInfo_1_active-connections.txt
		:: Listing the DNS queries cache
		:: ipconfig.exe /displaydns reference: Malware Forensics page 27 
			echo Command Executed: ipconfig.exe /displaydns > %vol_outpath%\NetworkInfo_2_dns-queries-cache.txt
			echo: >> %vol_outpath%\NetworkInfo_2_dns-queries-cache.txt
			echo %DATE% %TIME% - Running %WINDIR%\System32\ipconfig.exe /displaydns on %COMPUTERNAME% to obtain DNS queries cache
			echo %DATE% %TIME% - Running %WINDIR%\System32\ipconfig.exe /displaydns on %COMPUTERNAME% to obtain DNS queries cache >> %c_drive%:\Data-%case%\Collection.log
			%WINDIR%\System32\ipconfig.exe /displaydns >> %vol_outpath%\NetworkInfo_2_dns-queries-cache.txt
		:: Listing the netbios sessions
		:: nbtstat.exe -s reference: Malware Forensics page 29
			echo Command Executed: nbtstat.exe -s > %vol_outpath%\NetworkInfo_3_netbios-sessions.txt
			echo: >> %vol_outpath%\NetworkInfo_3_netbios-sessions.txt
			echo %DATE% %TIME% - Running %WINDIR%\System32\nbtstat.exe -s on %COMPUTERNAME% to obtain NetBios sessions
			echo %DATE% %TIME% - Running %WINDIR%\System32\nbtstat.exe -s on %COMPUTERNAME% to obtain NetBios sessions >> %c_drive%:\Data-%case%\Collection.log
			%WINDIR%\System32\nbtstat.exe -s >> %vol_outpath%\NetworkInfo_3_netbios-sessions.txt
		:: Listing the netbios cache
		:: nbtstat.exe -c reference: Malware Forensics page 30 or WFA page 20
			echo Command Executed: nbtstat.exe -c > %vol_outpath%\NetworkInfo_4_netbios-cache.txt
			echo: >> %vol_outpath%\NetworkInfo_4_netbios-cache.txt
			echo %DATE% %TIME% - Running %WINDIR%\System32\nbtstat.exe -c on %COMPUTERNAME% to obtain NetBios cache
			echo %DATE% %TIME% - Running %WINDIR%\System32\nbtstat.exe -c on %COMPUTERNAME% to obtain NetBios cache >> %c_drive%:\Data-%case%\Collection.log
			%WINDIR%\System32\nbtstat.exe -c >> %vol_outpath%\NetworkInfo_4_netbios-cache.txt
		:: Listing the recently transered files over Netbios
		:: net.exe file reference: Malware Forensics page 30 
			echo Command Executed: net.exe file > %vol_outpath%\NetworkInfo_5_file-transfer-over-netbios.txt
			echo: >> %vol_outpath%\NetworkInfo_5_file-transfer-over-netbios.txt
			echo %DATE% %TIME% - Running %WINDIR%\System32\net.exe file on %COMPUTERNAME% to obtain the recently transered files over Netbios
			echo %DATE% %TIME% - Running %WINDIR%\System32\net.exe file on %COMPUTERNAME% to obtain the recently transered files over Netbios >> %c_drive%:\Data-%case%\Collection.log
			%WINDIR%\System32\net.exe file >> %vol_outpath%\NetworkInfo_5_file-transfer-over-netbios.txt
		:: Listing the arp cache
		:: arp.exe -a reference: Malware Forensics page 31
			echo Command Executed: arp.exe -a > %vol_outpath%\NetworkInfo_6_arp-cache.txt
			echo: >> %vol_outpath%\NetworkInfo_6_arp-cache.txt
			echo %DATE% %TIME% - Running %WINDIR%\System32\arp.exe -a on %COMPUTERNAME% to obtain arp cache
			echo %DATE% %TIME% - Running %WINDIR%\System32\arp.exe -a on %COMPUTERNAME% to obtain arp cache >> %c_drive%:\Data-%case%\Collection.log
			%WINDIR%\System32\arp.exe -a >> %vol_outpath%\NetworkInfo_6_arp-cache.txt
		:: Listing the routing table
		:: netstate.exe -r reference: WFA page 23
			echo Command Executed: netstat.exe -r > %vol_outpath%\NetworkInfo_7_routing-table.txt
			echo: >> %vol_outpath%\NetworkInfo_7_routing-table.txt
			echo %DATE% %TIME% - Running %WINDIR%\System32\netstat.exe -r on %COMPUTERNAME% to obtain the routing table
			echo %DATE% %TIME% - Running %WINDIR%\System32\netstat.exe -r on %COMPUTERNAME% to obtain the routing table >> %c_drive%:\Data-%case%\Collection.log
			%WINDIR%\System32\netstat.exe -r >> %vol_outpath%\NetworkInfo_7_routing-table.txt
		:: Listing the port to process mapping
		:: openports.exe -lines -path reference: Malware Forensics page 49
			echo Command Executed: openports.exe -lines -path > %vol_outpath%\NetworkInfo_8_port-to-process-mapping_grouped.txt
			echo: >> %vol_outpath%\NetworkInfo_8_port-to-process-mapping_grouped.txt
			echo %DATE% %TIME% - Running tools\openports.exe -lines -path on %COMPUTERNAME% to obtain the port to process mapping grouped together
			echo %DATE% %TIME% - Running tools\openports.exe -lines -path on %COMPUTERNAME% to obtain the port to process mapping grouped together >> %c_drive%:\Data-%case%\Collection.log
			tools\openports.exe -lines -path >> %vol_outpath%\NetworkInfo_8_port-to-process-mapping_grouped.txt
		:: Listing the port to process mapping
		:: tcpvcon -a -c reference: WFA page 32
			echo %DATE% %TIME% - Running tools\tcpvcon.exe -a -c /accepteula on %COMPUTERNAME% to obtain the port to process mapping in csv format
			echo %DATE% %TIME% - Running tools\tcpvcon.exe -a -c /accepteula on %COMPUTERNAME% to obtain the port to process mapping in csv format >> %c_drive%:\Data-%case%\Collection.log
			tools\tcpvcon.exe -a -c /accepteula >> %vol_outpath%\NetworkInfo_8_port-to-process-mapping_csv.csv
	:: Collecting logged on users information
		echo %DATE% %TIME% - Collecting logged on users information from %COMPUTERNAME% volatile data
		echo %DATE% %TIME% - Collecting logged on users information from %COMPUTERNAME% volatile data >> %c_drive%:\Data-%case%\Collection.log
		:: Listing the locally and remotely logged on users including those accessing resource shares
		:: psloggedon.exe reference: Malware Forensics page 24 or WFA page 17
			echo Command Executed: psloggedon.exe /accepteula > %vol_outpath%\UserInfo_1_locally-remotely-logged-on-users.txt
			echo: >> %vol_outpath%\UserInfo_1_locally-remotely-logged-on-users.txt
			echo %DATE% %TIME% - Running tools\psloggedon.exe /accepteula on %COMPUTERNAME% to obtain the locally and remotely logged on users including those accessing resource shares
			echo %DATE% %TIME% - Running tools\psloggedon.exe /accepteula on %COMPUTERNAME% to obtain the locally and remotely logged on users including those accessing resource shares >> %c_drive%:\Data-%case%\Collection.log
			tools\psloggedon.exe /accepteula >> %vol_outpath%\UserInfo_1_locally-remotely-logged-on-users.txt
		:: Listing the remote users IP addresses
		:: net.exe sessions reference: WFA page 17 
			echo Command Executed: net.exe sessions > %vol_outpath%\UserInfo_2_remote-users-ip-addresses.txt
			echo: >> %vol_outpath%\UserInfo_2_remote-users-ip-addresses.txt
			echo %DATE% %TIME% - Running %WINDIR%\System32\net.exe sessions on %COMPUTERNAME% to obtain the remote users IP addresses
			echo %DATE% %TIME% - Running %WINDIR%\System32\net.exe sessions on %COMPUTERNAME% to obtain the remote users IP addresses >> %c_drive%:\Data-%case%\Collection.log
			%WINDIR%\System32\net.exe sessions >> %vol_outpath%\UserInfo_2_remote-users-ip-addresses.txt
		:: Listing the active logon sessions
		:: logonsessions.exe reference: Malware Forensics page 25 or WFA page 18
			echo Command Executed: logonsessions.exe /accepteula > %vol_outpath%\UserInfo_3_active-logon-sessions.txt
			echo: >> %vol_outpath%\UserInfo_3_active-logon-sessions.txt
			echo %DATE% %TIME% - Running tools\logonsessions.exe /accepteula on %COMPUTERNAME% to obtain the active logon sessions
			echo %DATE% %TIME% - Running tools\logonsessions.exe /accepteula on %COMPUTERNAME% to obtain the active logon sessions >> %c_drive%:\Data-%case%\Collection.log
			tools\logonsessions.exe /accepteula >> %vol_outpath%\UserInfo_3_active-logon-sessions.txt
	:: Collecting opened files information
		echo %DATE% %TIME% - Collecting opened files information from %COMPUTERNAME% volatile data
		echo %DATE% %TIME% - Collecting opened files information from %COMPUTERNAME% volatile data >> %c_drive%:\Data-%case%\Collection.log
		:: Listing the open files on the computer
		:: openedfilesview.exe /stext reference: Malware Forensics page 58 and WFA page 19
			echo %DATE% %TIME% - Running tools\openedfilesview.exe /stext on %COMPUTERNAME% to obtain the open files on the computer
			echo %DATE% %TIME% - Running tools\openedfilesview.exe /stext on %COMPUTERNAME% to obtain the open files on the computer >> %c_drive%:\Data-%case%\Collection.log	
			START /WAIT tools\openedfilesview.exe /stext %vol_outpath%\OpenedFilesInfo_1_opened-files.txt
		:: Listing the remotely opened files
		:: psfile.exe reference: Malware Forensics page 59 or WFA page 19
			echo Command Executed: psfile.exe /accepteula > %vol_outpath%\OpenedFilesInfo_2_remotely-opened-files.txt
			echo: >> %vol_outpath%\OpenedFilesInfo_2_remotely-opened-files.txt
			echo %DATE% %TIME% - Running tools\psfile.exe /accepteula on %COMPUTERNAME% to obtain the remotely opened files
			echo %DATE% %TIME% - Running tools\psfile.exe /accepteula on %COMPUTERNAME% to obtain the remotely opened files >> %c_drive%:\Data-%case%\Collection.log
			tools\psfile.exe /accepteula >> %vol_outpath%\OpenedFilesInfo_2_remotely-opened-files.txt
	:: Collecting misc information
		echo %DATE% %TIME% - Collecting misc information from %COMPUTERNAME% volatile data
		echo %DATE% %TIME% - Collecting misc information from %COMPUTERNAME% volatile data >> %c_drive%:\Data-%case%\Collection.log
		:: Listing the clipboard contents on the computer
		:: pclip.exe reference: Malware Forensics page 63 and WFA page 37
			echo Command Executed: pclip.exe > %vol_outpath%\MiscInfo_1_clipboard-contents.txt
			echo: >> %vol_outpath%\MiscInfo_1_clipboard-contents.txt
			echo %DATE% %TIME% - Running tools\pclip.exe on %COMPUTERNAME% to obtain the clipboard contents on the computer
			echo %DATE% %TIME% - Running tools\pclip.exe on %COMPUTERNAME% to obtain the clipboard contents on the computer >> %c_drive%:\Data-%case%\Collection.log
			tools\pclip.exe >> %vol_outpath%\MiscInfo_1_clipboard-contents.txt
	:: Collecting system information
		echo %DATE% %TIME% - Collecting system information from %COMPUTERNAME% volatile data
		echo %DATE% %TIME% - Collecting system information from %COMPUTERNAME% volatile data >> %c_drive%:\Data-%case%\Collection.log
		:: Listing the operating system version
		:: ver reference: Malware Forensics page 19
			echo Command Executed: ver.exe > %vol_outpath%\SystemInfo_1_os-version.txt
			echo: >> %vol_outpath%\SystemInfo_1_os-version.txt
			echo %DATE% %TIME% - Running ver on %COMPUTERNAME% to obtain the operating system version
			echo %DATE% %TIME% - Running ver on %COMPUTERNAME% to obtain the operating system version >> %c_drive%:\Data-%case%\Collection.log
			ver >> %vol_outpath%\SystemInfo_1_os-version.txt
		:: Listing the system's uptime
		:: uptime.exe reference: Malware Forensics page 21
			echo Command Executed: uptime.exe > %vol_outpath%\SystemInfo_2_system-uptime.txt
			echo: >> %vol_outpath%\SystemInfo_2_system-uptime.txt
			:: Documenting the date and time in output to help calculate the uptime
			FOR /F "tokens=*" %%i in ('date /t') do set _date=%%i 
			echo %COMPUTERNAME% date for comparison: %_date% >> %vol_outpath%\SystemInfo_2_system-uptime.txt
			FOR /F "tokens=*" %%i in ('time /t') do set _time=%%i 
			echo %COMPUTERNAME% time for comparison: %_time% >> %vol_outpath%\SystemInfo_2_system-uptime.txt
			echo: >> %vol_outpath%\SystemInfo_2_system-uptime.txt
			echo: >> %vol_outpath%\SystemInfo_2_system-uptime.txt
			:: Continuing with getting the uptime
			echo %DATE% %TIME% - Running tools\uptime.exe on %COMPUTERNAME% to obtain the system's uptime
			echo %DATE% %TIME% - Running tools\uptime.exe on %COMPUTERNAME% to obtain the system's uptime >> %c_drive%:\Data-%case%\Collection.log
			tools\uptime.exe >> %vol_outpath%\SystemInfo_2_system-uptime.txt
		:: Listing the network configuration
		:: ipconfig /all reference: Malware Forensics page 19 and WFA page 34
			echo Command Executed: ipconfig /all > %vol_outpath%\SystemInfo_3_network-configuration.txt
			echo: >> %vol_outpath%\SystemInfo_3_network-configuration.txt
			echo %DATE% %TIME% - Running ipconfig /all on %COMPUTERNAME% to obtain the network configuration
			echo %DATE% %TIME% - Running ipconfig /all on %COMPUTERNAME% to obtain the network configuration >> %c_drive%:\Data-%case%\Collection.log
			%WINDIR%\System32\ipconfig /all >> %vol_outpath%\SystemInfo_3_network-configuration.txt
		:: Listing the enabled network protocols
		:: urlprotocolview.exe /stext reference: Malware Forensics page 20
			echo %DATE% %TIME% - Running tools\urlprotocolview.exe /stext on %COMPUTERNAME% to obtain the enabled network protocols
			echo %DATE% %TIME% - Running tools\urlprotocolview.exe /stext on %COMPUTERNAME% to obtain the enabled network protocols >> %c_drive%:\Data-%case%\Collection.log	
			tools\urlprotocolview.exe /stext %vol_outpath%\SystemInfo_4_enabled-network-protocols.txt
		:: Listing the enabled network protocols
		:: urlprotocolview.exe /stab reference: Malware Forensics page 20
			echo %DATE% %TIME% - Running tools\urlprotocolview.exe /stab on %COMPUTERNAME% to obtain the enabled network protocols in tab-delimited text file
			echo %DATE% %TIME% - Running tools\urlprotocolview.exe /stab on %COMPUTERNAME% to obtain the enabled network protocolsin tab-delimited text file >> %c_drive%:\Data-%case%\Collection.log	
			tools\urlprotocolview.exe /stab %vol_outpath%\SystemInfo_4_enabled-network-protocols_tab.csv
		:: Listing the network adapters in promiscuous mode
		:: promiscdetect.exe reference: Malware Forensics page 19 and WFA page 35
			echo Command Executed: promiscdetect.exe > %vol_outpath%\SystemInfo_5_promiscuous-adapters.txt
			echo: >> %vol_outpath%\SystemInfo_5_promiscuous-adapters.txt
			echo %DATE% %TIME% - Running tools\promiscdetect.exe on %COMPUTERNAME% to obtain the network adapters in promiscuous mode
			echo %DATE% %TIME% - Running tools\promiscdetect.exe on %COMPUTERNAME% to obtain the network adapters in promiscuous mode >> %c_drive%:\Data-%case%\Collection.log
			tools\promiscdetect.exe >> %vol_outpath%\SystemInfo_5_promiscuous-adapters.txt	
	echo:
	echo %DATE% %TIME% - Completed acquring %COMPUTERNAME%'s volatile data
	echo %DATE% %TIME% - Completed acquring %COMPUTERNAME%'s volatile data >> %c_drive%:\Data-%case%\Collection.log
	echo:
	:: Exiting the acquire_memory function
	if %selection% == 4 goto :acquire_nonvolatile
	pause
	cls
	goto :menu
:acquire_nonvolatile
	:: The acquire_nonvolatile function obtains select data from the system to help with triage
	:: The naming convention for the output folders is as follows: TypeInfo
		:: The TypeInfo specifies the collected information such as AutorunInfo
	:: Creating output directory
	if not exist %c_drive%:\Data-%case%\%computername%-%timestamp%\nonvolatile-data (
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the non-volatile data
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the non-volatile data >> %c_drive%:\Data-%case%\Collection.log
		tools\mkdir.exe %c_drive%:\Data-%case%\%computername%-%timestamp%\nonvolatile-data
		)
	::Creating output directories
	if not exist %c_drive%:\Data-%case%\%computername%-%timestamp%\nonvolatile-data\system-info (
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the system-info non-volatile data
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the system-info non-volatile data >> %c_drive%:\Data-%case%\Collection.log
		tools\mkdir.exe %c_drive%:\Data-%case%\%computername%-%timestamp%\nonvolatile-data\system-info
		)
		if not exist %c_drive%:\Data-%case%\%computername%-%timestamp%\nonvolatile-data\autoruns (
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the autoruns non-volatile data
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the autoruns non-volatile data >> %c_drive%:\Data-%case%\Collection.log
		tools\mkdir.exe %c_drive%:\Data-%case%\%computername%-%timestamp%\nonvolatile-data\autoruns
		)
		if not exist %c_drive%:\Data-%case%\%computername%-%timestamp%\nonvolatile-data\group-policy (
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the group-policy non-volatile data
		echo %DATE% %TIME% - Running tools\mkdir.exe on %COMPUTERNAME% to create directory to store the group-policy non-volatile data >> %c_drive%:\Data-%case%\Collection.log
		tools\mkdir.exe %c_drive%:\Data-%case%\%computername%-%timestamp%\nonvolatile-data\group-policy
		)
	:: Creating a variable to the volatile-data directory to shorten the code
	set nonvol_outpath=%c_drive%:\Data-%case%\%computername%-%timestamp%\nonvolatile-data
	:: Collecting non-volatile system information
		echo %DATE% %TIME% - Collecting non-volatile system information from %COMPUTERNAME%
		echo %DATE% %TIME% - Collecting non-volatile system information from %COMPUTERNAME% >> %c_drive%:\Data-%case%\Collection.log
		:: Listing the installed software
		:: winaudit.exe /r=s reference: not covered in Malware Forensics or WFA 
			echo %DATE% %TIME% - Running tools\winaudit.exe /r=s on %COMPUTERNAME% to obtain the installed software
			echo %DATE% %TIME% - Running tools\winaudit.exe /r=s on %COMPUTERNAME% to obtain the installed software >> %c_drive%:\Data-%case%\Collection.log
			START /WAIT tools\winaudit.exe /r=s /o=text /f=%nonvol_outpath%\system-info\%COMPUTERNAME%-installed-software.txt /f=%nonvol_outpath%\system-info\%COMPUTERNAME%-installed-software_log.txt
		:: Listing the security settings
		:: winaudit.exe /r=x reference: not covered in Malware Forensics or WFA 
			echo %DATE% %TIME% - Running tools\winaudit.exe /r=x on %COMPUTERNAME% to obtain the security settings
			echo %DATE% %TIME% - Running tools\winaudit.exe /r=x on %COMPUTERNAME% to obtain the security settings >> %c_drive%:\Data-%case%\Collection.log
			START /WAIT tools\winaudit.exe /r=x /o=text /f=%nonvol_outpath%\system-info\%COMPUTERNAME%-security-settings.txt /f=%nonvol_outpath%\system-info\%COMPUTERNAME%-security-settings_log.txt
		:: Listing the configured users and groups
		:: winaudit.exe /r=u reference: not covered in Malware Forensics or WFA 
			echo %DATE% %TIME% - Running tools\winaudit.exe /r=u on %COMPUTERNAME% to obtain the configured users and groups
			echo %DATE% %TIME% - Running tools\winaudit.exe /r=u on %COMPUTERNAME% to obtain the configured users and groups >> %c_drive%:\Data-%case%\Collection.log
			START /WAIT tools\winaudit.exe /r=u /o=text /f=%nonvol_outpath%\system-info\%COMPUTERNAME%-users-groups.txt /f=%nonvol_outpath%\system-info\%COMPUTERNAME%-users-groups_log.txt
		:: Listing the computer's devices
		:: winaudit.exe /r=z reference: not covered in Malware Forensics or WFA 
			echo %DATE% %TIME% - Running tools\winaudit.exe /r=z on %COMPUTERNAME% to obtain the computer's devices
			echo %DATE% %TIME% - Running tools\winaudit.exe /r=z on %COMPUTERNAME% to obtain the computer's devices >> %c_drive%:\Data-%case%\Collection.log
			START /WAIT tools\winaudit.exe /r=z /o=text /f=%nonvol_outpath%\system-info\%COMPUTERNAME%-devices.txt /f=%nonvol_outpath%\system-info\%COMPUTERNAME%-devices_log.txt
	:: Collecting autostarting locations
		echo %DATE% %TIME% - Collecting autostarting locations information from %COMPUTERNAME%
		echo %DATE% %TIME% - Collecting autostarting locations information from %COMPUTERNAME% >> %c_drive%:\Data-%case%\Collection.log
		:: Listing the system's autostarting locations
		:: autorunsc.exe reference: Malware Forensics page 69 or WFA page 44
			echo Command Executed: autorunsc.exe -a /accepteula > %nonvol_outpath%\autoruns\%COMPUTERNAME%-autostarting-locations.txt
			echo: >> %nonvol_outpath%\autoruns\%COMPUTERNAME%-autostarting-locations.txt
			echo %DATE% %TIME% - Running tools\autorunsc.exe -a /accepteula on %COMPUTERNAME% to obtain the autostarting locations
			echo %DATE% %TIME% - Running tools\autorunsc.exe -a /accepteula on %COMPUTERNAME% to obtain the autostarting locations >> %c_drive%:\Data-%case%\Collection.log
			tools\autorunsc.exe -a /accepteula >> %nonvol_outpath%\autoruns\%COMPUTERNAME%-autostarting-locations.txt
		:: Listing the system's autostarting locations in csv format
		:: autorunsc.exe reference: Malware Forensics page 69 or WFA page 44
			echo %DATE% %TIME% - Running tools\autorunsc.exe -a -c /accepteula on %COMPUTERNAME% to obtain the autostarting locations in csv format
			echo %DATE% %TIME% - Running tools\autorunsc.exe -a -c /accepteula on %COMPUTERNAME% to obtain the autostarting locations in csv format >> %c_drive%:\Data-%case%\Collection.log
			tools\autorunsc.exe -a -c /accepteula >> %nonvol_outpath%\autoruns\%COMPUTERNAME%-autostarting-locations_csv.csv
	:: Collecting the group policy information applied to the system
		echo %DATE% %TIME% - Collecting group policy information from %COMPUTERNAME%
		echo %DATE% %TIME% - Collecting group policy information from %COMPUTERNAME% >> %c_drive%:\Data-%case%\Collection.log
		:: gplist.exe reference: Malware Forensics page 73
			echo Command Executed: gplist.exe > %nonvol_outpath%\group-policy\%COMPUTERNAME%-group-policy-listing.txt
			echo: >> %nonvol_outpath%\group-policy\%COMPUTERNAME%-group-policy-listing.txt
			echo %DATE% %TIME% - Running tools\gplist.exe on %COMPUTERNAME% to obtain the computer's group policy listing 
			echo %DATE% %TIME% - Running tools\gplist.exe on %COMPUTERNAME% to obtain the computer's group policy listing >> %c_drive%:\Data-%case%\Collection.log
			tools\gplist.exe >> %nonvol_outpath%\group-policy\%COMPUTERNAME%-group-policy-listing.txt
		:: gpresult.exe reference: Malware Forensics page 73
			echo Command Executed: gpresult /Z > %nonvol_outpath%\group-policy\%COMPUTERNAME%-group-policy-RSoP.txt
			echo: >> %nonvol_outpath%\group-policy\%COMPUTERNAME%-group-policy-RSoP.txt
			echo %DATE% %TIME% - Running gpresult /Z on %COMPUTERNAME% to obtain the computer's group policy Resultant Set of Policy (RSoP) information
			echo %DATE% %TIME% - Running gpresult /Z on %COMPUTERNAME% to obtain the computer's group policy Resultant Set of Policy (RSoP) information >> %c_drive%:\Data-%case%\Collection.log
			gpresult /Z >> %nonvol_outpath%\group-policy\%COMPUTERNAME%-group-policy-RSoP.txt
	echo:
	echo %DATE% %TIME% - Completed acquring %COMPUTERNAME%'s non-volatile data >> %c_drive%:\Data-%case%\Collection.log
	:: Below is for messaging
	if %selection% == 4 echo:
	if %selection% == 4 echo:
	if %selection% == 4 echo %DATE% %TIME% - Completed acquring %COMPUTERNAME%'s memory, volatile data, and non-volatile data
	if %selection% == 4 echo %DATE% %TIME% - Completed acquring %COMPUTERNAME%'s memory, volatile data, and non-volatile data >> %c_drive%:\Data-%case%\Collection.log
	echo:
	:: Exiting the acquire_memory function
	pause
	cls
	goto :menu
:: --------------------------------------------------------------------------------------------------------------------------
:: Exit Processing Area
:: --------------------------------------------------------------------------------------------------------------------------
:: This section performs some additional documentation before the script exits 
:exit
	:: The lines below document when the script exited
	echo %DATE% %TIME% - Exiting collection script and stopping logging for computer %COMPUTERNAME% >> %c_drive%:\Data-%case%\Collection.log
	
:: --------------------------------------------------------------------------------------------------------------------------