#Public MAC-IR.sh
#Version 0.1
#Author:Tom Webb
#usage ir_script.sh /path/to/folder containing bin and lib directory
#output is to standard out

#!/bin/bash
clear

if [[ $EUID -ne 0 ]]; then
 echo "You must be root or sudo to run script"
 exit 1;
fi

#Error if no file given
if [ -z "$1" ]; then
 echo -e "\nUsage: `basename $0` usage ir_script.sh /path/to/folder containing bin and lib directory"
 exit 1
fi

if [[ ! -d "$1" ]]; then
 echo "Directory does not exist"
 exit 1;
fi

BINDIR="$1/bin" #$1 is command line argument for path
LD_LIBRARY_PATH="$1/lib"
PATH=$BINDIR

IR_echo "========="
IR_echo "Start Date:"
IR_echo "========="
IR_date
IR_echo

IR_echo "========="
IR_echo "hostname:"
IR_echo "========="
IR_hostname
IR_echo

IR_echo "==================================="
IR_echo "netstat output(current connections)"
IR_echo "==================================="
IR_netstat -an
IR_echo

IR_echo "==================================="
IR_echo "lsof -i Network Connections"
IR_echo "==================================="
IR_lsof -i
IR_echo

IR_echo "=========================="
IR_echo "currently logged in users:"
IR_echo "=========================="
IR_who
IR_echo

IR_echo "=========================="
IR_echo "List of running processes:"
IR_echo "=========================="
IR_ps auxwww
IR_echo

IR_echo "=========================="
IR_echo "Memory Mapping of all Processes"
IR_echo "=========================="
for i in `IR_ps aux| IR_awk '{print $2}'`; do IR_vmmap $i ; done
IR_echo

IR_echo "============"
IR_echo "List of open files:"
IR_echo "============"
IR_lsof
IR_echo

IR_echo
IR_echo "======================"
IR_echo "serversetup -getDefaultDNSServer :"
IR_echo "======================"
IR_serversetup -getDefaultDNSServer *
IR_echo

IR_echo "=============="
IR_echo "routing table:"
IR_echo "=============="
IR_netstat -rn
IR_echo

IR_echo "=================="
IR_echo "arp table entries:"
IR_echo "=================="
IR_arp -an
IR_echo

IR_echo "======================"
IR_echo "Network interface info"
IR_echo "======================"
IR_ifconfig -a
IR_echo
IR_ifconfig -L
IR_echo

IR_echo "======================"
IR_echo "Mount"
IR_echo "======================"
IR_mount
IR_echo

IR_echo "======================"
IR_echo "disktool"
IR_echo "======================"
IR_disktool -l
IR_echo

IR_echo "======================"
IR_echo "mac-robber"
IR_echo "======================"
IR_mac-robber /
IR_echo

IR_echo "======================"
IR_echo "LS -LAR /System/Library/StartupItems"
IR_echo "======================"
IR_ls -laR /System/Library/StartupItems
IR_echo

IR_echo "======================"
IR_echo "LS -LAR /System/Library/StartupItems"
IR_echo "======================"
IR_ls -laR /System/Library/StartupItems
IR_echo

IR_echo "======================"
IR_echo "LS -LAR /Library/StartupItems"
IR_echo "======================"
IR_ls -laR /Library/StartupItems

IR_echo "=============================================="
IR_echo "/etc/hosts.allow"
IR_echo "=============================================="
IR_cat /etc/hosts.allow
IR_echo

IR_echo "=============================================="
IR_echo "cat /etc/passwd"
IR_echo "=============================================="
IR_cat /etc/passwd
IR_echo

IR_echo "=============================================="
IR_echo "cat /etc/group"
IR_echo "=============================================="
IR_cat /etc/group
IR_echo

IR_echo "==========="
IR_echo "   fstab   "
IR_echo "==========="
IR_cat /etc/fstab
IR_echo

IR_echo "==========="
IR_echo "SystemVersion.plist"
IR_echo "==========="
IR_PlistBuddy -c  Print /System/Library/CoreServices/SystemVersion.plist
IR_echo
IR_echo

IR_echo "==========="
IR_echo "ServerVersion.plist"
IR_echo "==========="
IR_PlistBuddy -c  Print /System/Library/CoreServices/ServerVersion.plist
IR_echo
IR_echo

IR_echo "==========="
IR_echo " SoftwareUpdate.plist  (Last softwareupdate)    "
IR_echo "==========="
IR_PlistBuddy -c  Print /Library/Preferences/com.apple.SoftwareUpdate.plist
IR_echo
IR_echo

IR_echo "==========="
IR_echo " /Library/Preferences/com.apple.preferences.accounts.plist  "
IR_echo "List of Deleted User Accounts "
IR_echo "==========="
IR_PlistBuddy -c  Print /Library/Preferences/com.apple.preferences.accounts.plist
IR_echo
IR_echo

for i in `IR_ls -l /Users |IR_awk '{print $9}'`; do #This setup up each user with a dir as a variable
 IR_echo "User $i"
 IR_PlistBuddy -c Print /Users/$i/Library/Safari/LastSession.plist
 IR_echo
done

IR_echo "==========="
IR_echo " /Library/Preferences/com.apple.alf.plist"
IR_echo "Firewall settings "
IR_echo "==========="
IR_PlistBuddy -c  Print /Library/Preferences/com.apple.alf.plist
IR_echo
IR_echo

IR_echo "========="
IR_echo "End Date:"
IR_echo "========="
IR_date
IR_echo

