#!/bin/bash
#Created by:Tom Webb
#Version 0.1
#usage mac-ir-create.sh filelist

#Error if no file given
if [ -z "$1" ]; then
 echo -e "\nUsage: `basename $0` /path/to/file list"
 exit 1
fi

#Error if not sudo/root
if [[ $EUID -ne 0 ]]; then
 echo "You must be root/sudo to run the script"
 exit 1;
fi

echo "Enter the path where you want the /bin and /lib folders to be created"
read IR_LOCATION

#Setup DIR PATH
mkdir $IR_LOCATION/bin
mkdir $IR_LOCATION/lib

while read line; do

 FIND_BIN=`which $line` #Find the location of the binary file
 if  [ -z $FIND_BIN ]; then #if results empty
    echo "$line is not installed or in your path"
 else
   cp $FIND_BIN $IR_LOCATION/bin/IR_$line #Copies binary file to the new directory and renames it
   for i in `otool -L $FIND_BIN |sed '1d' | cut -d ' ' -f1`; #Takes the path of the bin file and looks up required libraries and removes the 1st line and set as a variable
   do
      cp $i $IR_LOCATION/lib #Copies the library file to the new IR Location for each library
   done
 fi
done <$1 #Use file from command line argument

