#!/bin/bash

CURDIR=`./linux_x86/pwd`
BINDIR="$CURDIR/linux_x86"
$BINDIR/echo "All output can be redirected to your choice of storage or netcat pipe."

$BINDIR/echo "========="
$BINDIR/echo "hostname:"
$BINDIR/echo "========="
$BINDIR/hostname
$BINDIR/echo 

$BINDIR/echo "========="
$BINDIR/echo "cpu info:"
$BINDIR/echo "========="
$BINDIR/cat /proc/cpuinfo
$BINDIR/echo 

$BINDIR/echo "========="
$BINDIR/echo "disk use:"
$BINDIR/echo "========="
$BINDIR/df -hl
$BINDIR/echo 

$BINDIR/echo "============="
$BINDIR/echo "fdisk output:"
$BINDIR/echo "============="
fdisk -l
#need a binary for this
$BINDIR/echo 

$BINDIR/echo "========="
$BINDIR/echo "version:"
$BINDIR/echo "========="
$BINDIR/cat /proc/version
$BINDIR/echo 

$BINDIR/echo "==================="
$BINDIR/echo "kernel boot params:"
$BINDIR/echo "==================="
$BINDIR/cat /proc/cmdline
$BINDIR/echo 

$BINDIR/echo "=================================="
$BINDIR/echo "Local shell environment variables:"
$BINDIR/echo "=================================="
$BINDIR/env
$BINDIR/echo 

$BINDIR/echo "=========================="
$BINDIR/echo "currently logged in users:"
$BINDIR/echo "=========================="
$BINDIR/who
$BINDIR/echo 

$BINDIR/echo "=========================="
$BINDIR/echo "List of running processes:"
$BINDIR/echo "=========================="
ps -efl
#$BINDIR/ps -efl ; need static ps command

$BINDIR/echo
$BINDIR/echo "======================"
$BINDIR/echo "Network interface info"
$BINDIR/echo "======================"
$BINDIR/ifconfig -a
$BINDIR/echo
$BINDIR/ifconfig -s
$BINDIR/echo

$BINDIR/echo
$BINDIR/echo "=================="
$BINDIR/echo "arp table entries:"
$BINDIR/echo "=================="
$BINDIR/arp -n
$BINDIR/echo

$BINDIR/echo
$BINDIR/echo "=================="
$BINDIR/echo "/etc/hosts file:"
$BINDIR/echo "=================="
$BINDIR/cat /etc/hosts
$BINDIR/echo

$BINDIR/echo
$BINDIR/echo "======================"
$BINDIR/echo "/etc/resolv.conf file:"
$BINDIR/echo "======================"
$BINDIR/cat /etc/resolv.conf
$BINDIR/echo

$BINDIR/echo
$BINDIR/echo "======================"
$BINDIR/echo "/etc/passwd file:"
$BINDIR/echo "======================"
$BINDIR/cat /etc/passwd
$BINDIR/echo

$BINDIR/echo
$BINDIR/echo "======================"
$BINDIR/echo "/etc/shadow file:"
$BINDIR/echo "======================"
$BINDIR/cat /etc/shadow
$BINDIR/echo

$BINDIR/echo
$BINDIR/echo "==================================="
$BINDIR/echo "netstat output(current connections)"
$BINDIR/echo "==================================="
$BINDIR/netstat -anp
$BINDIR/echo

$BINDIR/echo "=============="
$BINDIR/echo "routing table:"
$BINDIR/echo "=============="
$BINDIR/netstat -rn
$BINDIR/echo

$BINDIR/echo "==========================="
$BINDIR/echo "listening ports (via lsof):"
$BINDIR/echo "==========================="
$BINDIR/lsof -P -i -n
$BINDIR/echo

$BINDIR/echo "============"
$BINDIR/echo "lsof output:"
$BINDIR/echo "============"
$BINDIR/lsof 
$BINDIR/echo

$BINDIR/echo "============"
$BINDIR/echo "Memory info:"
$BINDIR/echo "============"
$BINDIR/cat /proc/meminfo
$BINDIR/echo 
$BINDIR/echo 

$BINDIR/echo "============"
$BINDIR/echo "Module info:"
$BINDIR/echo "============"
$BINDIR/cat /proc/modules
$BINDIR/echo 
$BINDIR/echo 

$BINDIR/echo "==========="
$BINDIR/echo "Mount info:"
$BINDIR/echo "==========="
$BINDIR/cat /proc/mounts
$BINDIR/echo 
$BINDIR/echo "Swap info:"
$BINDIR/echo "=========="
$BINDIR/cat /proc/swaps
$BINDIR/echo 
$BINDIR/echo "==========="
$BINDIR/echo "   fstab   "
$BINDIR/echo "==========="
$BINDIR/cat /etc/fstab
$BINDIR/echo 
$BINDIR/echo 


$BINDIR/echo "================================================================"
$BINDIR/echo "Running Process info:"
$BINDIR/echo "================================================================"
$BINDIR/ls /proc | sort -n | grep -v [a-z,A-Z] | while read PID
  do
	$BINDIR/echo "Process ID $PID:"
	$BINDIR/echo "/proc/$PID/cmdline:"
	$BINDIR/cat /proc/$PID/cmdline
	$BINDIR/echo
	$BINDIR/echo
	$BINDIR/echo "/proc/$PID/environ:"
	$BINDIR/cat /proc/$PID/environ
	$BINDIR/echo
	$BINDIR/echo
	$BINDIR/echo "/proc/$PID/maps:"
	$BINDIR/cat /proc/$PID/maps
	$BINDIR/echo
	$BINDIR/echo
	$BINDIR/echo "/proc/$PID/stat:"
	$BINDIR/cat /proc/$PID/stat
	$BINDIR/echo
	$BINDIR/echo
	$BINDIR/echo "/proc/$PID/statm:"
	$BINDIR/cat /proc/$PID/statm
	$BINDIR/echo
	$BINDIR/echo
	$BINDIR/echo "/proc/$PID/status:"
	$BINDIR/cat /proc/$PID/status
	$BINDIR/echo
	$BINDIR/echo
	$BINDIR/echo "/proc/$PID/mem:"
	$BINDIR/cat /proc/$PID/mem
	$BINDIR/echo
	$BINDIR/echo
	$BINDIR/echo "/proc/$PID/root:"
	$BINDIR/ls -ld /proc/$PID/root
	$BINDIR/echo
	$BINDIR/echo "/proc/$PID/cwd:"
	$BINDIR/ls -ld /proc/$PID/cwd
	$BINDIR/echo
	$BINDIR/echo "/proc/$PID/exe:"
	$BINDIR/ls -ld /proc/$PID/exe
	$BINDIR/echo
	$BINDIR/echo "/proc/$PID/fd/*:"
	$BINDIR/ls -lrta /proc/$PID/fd/
	$BINDIR/echo
	$BINDIR/echo "========================================================"
	$BINDIR/echo
  done

$BINDIR/echo "================="
$BINDIR/echo "SUID/SGID search:"
$BINDIR/echo "================="
$BINDIR/echo 
find / -perm -2000 -o -perm -4000 -print | xargs $BINDIR/ls -l {}

$BINDIR/echo "================="
$BINDIR/echo "File permissions:"
$BINDIR/echo "================="
$BINDIR/echo "/etc:"
$BINDIR/echo "-----"
$BINDIR/ls -lrta /etc
	$BINDIR/echo
$BINDIR/echo "/bin:"
$BINDIR/echo "-----"
$BINDIR/ls -lrta /bin
	$BINDIR/echo
$BINDIR/echo "/sbin:"
$BINDIR/echo "------"
$BINDIR/ls -lrta /sbin
	$BINDIR/echo
$BINDIR/echo "/usr:"
$BINDIR/echo "-----"
$BINDIR/ls -Rlrta /usr
	$BINDIR/echo
$BINDIR/echo "/var:"
$BINDIR/echo "-----"
$BINDIR/ls -Rlrta /var
	$BINDIR/echo
$BINDIR/echo "/dev:"
$BINDIR/echo "-----"
$BINDIR/ls -Rlrta /dev
	$BINDIR/echo
$BINDIR/echo "/home:"
$BINDIR/echo "------"
$BINDIR/ls -Rlrta /home
	$BINDIR/echo
$BINDIR/echo "/lib:"
$BINDIR/echo "------"
$BINDIR/ls -Rlrta /lib
	$BINDIR/echo
	$BINDIR/echo "========================================================"

$BINDIR/echo "================="
$BINDIR/echo "MD5SUMs:"
$BINDIR/echo "================="
$BINDIR/echo "/etc:"
$BINDIR/echo "-----"
$BINDIR/md5sum /etc/*
	$BINDIR/echo
$BINDIR/echo "/bin:"
$BINDIR/echo "-----"
$BINDIR/md5sum /bin/*
	$BINDIR/echo
$BINDIR/echo "/sbin:"
$BINDIR/echo "------"
$BINDIR/md5sum /sbin/*
	$BINDIR/echo
$BINDIR/echo "/usr:"
$BINDIR/echo "-----"
$BINDIR/md5sum /usr/*
	$BINDIR/echo
$BINDIR/echo "/var:"
$BINDIR/echo "-----"
$BINDIR/md5sum /var/*
	$BINDIR/echo
	$BINDIR/echo "========================================================"



#$BINDIR/echo "Make sure to grab /proc/kcore"


