﻿;Copyright (C) 2004-2012 John T. Haller
;Copyright (C) 2008 Travis Carrico

;Website: http://PortableApps.com/InfraRecorderPortable

;This software is OSI Certified Open Source Software.
;OSI Certified is a certification mark of the Open Source Initiative.

;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.

;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

!define PORTABLEAPPNAME "InfraRecorder Portable"
!define APPNAME "InfraRecorder"
!define NAME "InfraRecorderPortable"
!define VER "1.6.2.0"
!define WEBSITE "PortableApps.com/InfraRecorderPortable"
!define DEFAULTEXE "InfraRecorder.exe"
!define DEFAULTAPPDIR "InfraRecorder"
!define DEFAULTSETTINGSPATH "settings"
!define LAUNCHERLANGUAGE "English"

;=== Program Details
Name "${PORTABLEAPPNAME}"
OutFile "..\..\${NAME}.exe"
Caption "${PORTABLEAPPNAME} | PortableApps.com"
VIProductVersion "${VER}"
VIAddVersionKey ProductName "${PORTABLEAPPNAME}"
VIAddVersionKey Comments "Allows ${APPNAME} to be run from a removable drive.  For additional details, visit ${WEBSITE}"
VIAddVersionKey CompanyName "PortableApps.com"
VIAddVersionKey LegalCopyright "PortableApps.com and contributers"
VIAddVersionKey FileDescription "${PORTABLEAPPNAME}"
VIAddVersionKey FileVersion "${VER}"
VIAddVersionKey ProductVersion "${VER}"
VIAddVersionKey InternalName "${PORTABLEAPPNAME}"
VIAddVersionKey LegalTrademarks "PortableApps.com is a Trademark of Rare Ideas, LLC."
VIAddVersionKey OriginalFilename "${NAME}.exe"
;VIAddVersionKey PrivateBuild ""
;VIAddVersionKey SpecialBuild ""

;=== Runtime Switches
CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True
RequestExecutionLevel user
XPStyle On

; Best Compression
SetCompress Auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize On

;=== Add additional directories
!ifdef NSIS_UNICODE
	!addincludedir IncludeU
!else
	!addincludedir IncludeA
!endif
!addplugindir Plugins ;The Xml plug-in is only ansi, the header file takes care of it

;=== Include
;(Standard NSIS)
!include FileFunc.nsh
!include Registry.nsh
!include WinVer.nsh

;(Custom)
!include CheckForPlatformSplashDisable.nsh
!include ReadINIStrWithDefault.nsh
!include MyXML.nsh

;=== Program Icon
Icon "..\..\App\AppInfo\appicon.ico"

;=== Languages
LoadLanguageFile "${NSISDIR}\Contrib\Language files\${LAUNCHERLANGUAGE}.nlf"
!include PortableApps.comLauncherLANG_${LAUNCHERLANGUAGE}.nsh

Var PROGRAMDIRECTORY
Var SETTINGSDIRECTORY
Var ADDITIONALPARAMETERS
Var EXECSTRING
Var PROGRAMEXECUTABLE
Var INIPATH
Var DISABLESPLASHSCREEN
Var ISDEFAULTDIRECTORY
Var SECONDARYLAUNCH
Var MISSINGFILEORPATH
Var KEY1
Var KEY2
Var KEY3
Var KEY4
Var KEY5
Var KEY6
Var KEY7
Var KEY8
Var APPLANGUAGE

Section "Main"
	;=== Check if already running
	System::Call 'kernel32::CreateMutex(i 0, i 0, t "${NAME}2") i .r1 ?e'
	Pop $0
	StrCmp $0 0 CheckForINI
		StrCpy $SECONDARYLAUNCH "true"
	
	CheckForINI:
	;=== Find the INI file, if there is one
		IfFileExists "$EXEDIR\${NAME}.ini" "" NoINI
			StrCpy "$INIPATH" "$EXEDIR"
			Goto ReadINI

	ReadINI:
		;=== Read the parameters from the INI file
		${ReadINIStrWithDefault} $0 "$INIPATH\${NAME}.ini" "${NAME}" "${APPNAME}Directory" "App\${DEFAULTAPPDIR}"
		StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\$0"
		${ReadINIStrWithDefault} $0 "$INIPATH\${NAME}.ini" "${NAME}" "SettingsDirectory" "Data\${DEFAULTSETTINGSPATH}"
		StrCpy "$SETTINGSDIRECTORY" "$EXEDIR\$0"

		;=== Check that the above required parameters are present
		IfErrors NoINI

		${ReadINIStrWithDefault} $ADDITIONALPARAMETERS "$INIPATH\${NAME}.ini" "${NAME}" "AdditionalParameters" ""
		${ReadINIStrWithDefault} $PROGRAMEXECUTABLE "$INIPATH\${NAME}.ini" "${NAME}" "${APPNAME}Executable" "${DEFAULTEXE}"
		${ReadINIStrWithDefault} $DISABLESPLASHSCREEN "$INIPATH\${NAME}.ini" "${NAME}" "DisableSplashScreen" "false"

	;CleanUpAnyErrors:
		;=== Any missing unrequired INI entries will be an empty string, ignore associated errors
		ClearErrors

		;=== Correct PROGRAMEXECUTABLE if blank
		StrCmp $PROGRAMEXECUTABLE "" "" CheckForProgramINI
			StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"
			Goto CheckForProgramINI
			
	CheckForProgramINI:
		IfFileExists "$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" FoundProgramEXE NoProgramEXE

	NoINI:
		;=== No INI file, so we'll use the defaults
		StrCpy "$ADDITIONALPARAMETERS" ""
		StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"
		StrCpy "$DISABLESPLASHSCREEN" "false"

		IfFileExists "$EXEDIR\App\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" NoProgramEXE
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\App\${DEFAULTAPPDIR}"
			StrCpy "$SETTINGSDIRECTORY" "$EXEDIR\Data\${DEFAULTSETTINGSPATH}"
			StrCpy "$ISDEFAULTDIRECTORY" "true"
			GoTo FoundProgramEXE

	NoProgramEXE:
		;=== Program executable not where expected
		StrCpy $MISSINGFILEORPATH $PROGRAMEXECUTABLE
		MessageBox MB_OK|MB_ICONEXCLAMATION `$(LauncherFileNotFound)`
		Abort
		
	FoundProgramEXE:
		;=== Check if already running
		StrCmp $SECONDARYLAUNCH "true" CheckForSettings
		FindProcDLL::FindProc "$PROGRAMEXECUTABLE"                                  
		StrCmp $R0 "1" WarnAnotherInstance CheckForSettings

	WarnAnotherInstance:
		MessageBox MB_OK|MB_ICONINFORMATION `$(LauncherAlreadyRunning)`
		Abort
	
	CheckForSettings:
		IfFileExists "$SETTINGSDIRECTORY\Settings.xml" SettingsFound
		StrCmp $SECONDARYLAUNCH "true" SettingsFound
		;=== No settings found
		StrCmp $ISDEFAULTDIRECTORY "true" CopyDefaultSettings
		CreateDirectory $SETTINGSDIRECTORY
		Goto SettingsFound
	
	CopyDefaultSettings:
		CreateDirectory "$EXEDIR\Data"
		CreateDirectory "$EXEDIR\Data\settings"
		CopyFiles /SILENT $EXEDIR\App\DefaultData\settings\*.* $EXEDIR\Data\settings
		Goto SettingsFound

	SettingsFound:
		${CheckForPlatformSplashDisable} $DISABLESPLASHSCREEN
		StrCmp $DISABLESPLASHSCREEN "true" AdjustTempPath
			;=== Show the splash screen before processing the files
			InitPluginsDir
			File /oname=$PLUGINSDIR\splash.jpg "${NAME}.jpg"	
			newadvsplash::show /NOUNLOAD 1200 0 0 -1 /L $PLUGINSDIR\splash.jpg
	
	AdjustTempPath:
		CreateDirectory "$TEMP\${NAME}"
		${XmlWriteText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Global/TempPath "$TEMP\${NAME}"
		;=== Get the last path
		${XmlReadText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Dynamic/ShellDir $0
		StrCmp $0 "DEFAULT" "" AdjustShellDir
			ReadEnvStr $1 "PortableApps.comDocuments"
			StrCmp $1 "" SetRootDirectoryAsDefault
				${XmlWriteText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Dynamic/ShellDir $1
				Goto ResetWindowPosition
				
		SetRootDirectoryAsDefault:
			StrCpy $1 $EXEDIR 3
			${XmlWriteText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Dynamic/ShellDir $1
			Goto ResetWindowPosition
			
		AdjustShellDir:
			StrCpy $1 $0 "" 3 ;Path of last shell minus drive letter
			StrCpy $2 $EXEDIR 3 ;drive letter
			StrCpy $3 "$2$1"
			${XmlWriteText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Dynamic/ShellDir $3
		ResetWindowPosition:
			${XmlWriteText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Dynamic/WindowLeft ''
			${XmlWriteText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Dynamic/WindowRight ''
			${XmlWriteText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Dynamic/WindowTop ''
			${XmlWriteText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Dynamic/WindowBottom ''

	;=== Language switching
		ReadEnvStr $0 "PortableApps.comLocaleWinName"
		StrCmp $0 '' GetPassedParameters
		StrCpy $APPLANGUAGE $0 "" 5
		
	;SetLanguageStrings:
		${IfThen} $APPLANGUAGE == SERBIAN ${|} StrCpy $APPLANGUAGE "Serbian (Latin)" ${|}
		${IfThen} $APPLANGUAGE == PORTUGUESEBR ${|} StrCpy $APPLANGUAGE "Portuguese (Brazilian)" ${|}
		${IfThen} $APPLANGUAGE == SIMPCHINESE ${|} StrCpy $APPLANGUAGE "Chinese (Simplified)" ${|}
		${IfThen} $APPLANGUAGE == TRADCHINESE ${|} StrCpy $APPLANGUAGE "Chinese (Traditional)" ${|}
		${IfThen} $APPLANGUAGE == SPANISHINTERNATIONAL ${|} StrCpy $APPLANGUAGE "Spanish" ${|}
		
	;GetAppLanguage:
		${XmlReadText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Language/LanguageFile $0
		StrCpy $APPLANGUAGE $APPLANGUAGE.irl
		StrCmp $APPLANGUAGE $0 GetPassedParameters ;if the same, move on
		
	;SetAppLanguage:
		IfFileExists "$PROGRAMDIRECTORY\Languages\$APPLANGUAGE" "" GetPassedParameters
		${XmlWriteText} "$SETTINGSDIRECTORY\Settings.xml" /InfraRecorder/Settings/Language/LanguageFile $APPLANGUAGE

	GetPassedParameters:
		;=== Get any passed parameters
		${GetParameters} $0
		StrCmp "'$0'" "''" "" LaunchProgramParameters

		;=== No parameters
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE"`
		Goto AdditionalParameters

	LaunchProgramParameters:
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" $0`

	AdditionalParameters:
		StrCmp $ADDITIONALPARAMETERS "" CheckKey1

		;=== Additional Parameters
		StrCpy $EXECSTRING `$EXECSTRING $ADDITIONALPARAMETERS`
	
	CheckKey1:
		${registry::KeyExists} "HKEY_CURRENT_USER\Software\Cygnus Solutions" $R0
		StrCmp $R0 "0" CheckKey2
		StrCpy $KEY1 $R0
		Goto CheckKey5
	
	CheckKey2:
		${registry::KeyExists} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin" $R0
		StrCmp $R0 "0" CheckKey3
		StrCpy $KEY2 $R0
		Goto CheckKey5
		
	CheckKey3:
		${registry::KeyExists} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin\mounts v2" $R0
		StrCmp $R0 "0" CheckKey4
		StrCpy $KEY3 $R0
		
	CheckKey4:
		${registry::KeyExists} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin\Program Options" $R0
		StrCmp $R0 "0" CheckKey5
		StrCpy $KEY4 $R0
		
	CheckKey5:
		userInfo::getAccountType
		Pop $0
		StrCmp $0 "Admin" "" MoveSettings
		${registry::KeyExists} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions" $R0
		StrCmp $R0 "0" CheckKey6
		StrCpy $KEY5 $R0
		Goto MoveSettings
		
	CheckKey6:
		${registry::KeyExists} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin" $R0
		StrCmp $R0 "0" CheckKey7
		StrCpy $KEY6 $R0
		Goto MoveSettings
		
	CheckKey7:
		${registry::KeyExists} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin\mounts v2" $R0
		StrCmp $R0 "0" CheckKey8
		StrCpy $KEY7 $R0
	
	CheckKey8:
		${registry::KeyExists} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin\Program Options" $R0
		StrCmp $R0 "0" MoveSettings
		StrCpy $KEY8 $R0

	MoveSettings:
		StrCmp $SECONDARYLAUNCH "true" LaunchAndExit
		Sleep 100
		Rename "$SETTINGSDIRECTORY\Settings.xml" "$PROGRAMDIRECTORY\Settings.xml"
		Sleep 100
		Goto LaunchNow
	
	LaunchNow:
		Sleep 100
		ExecWait $EXECSTRING
		
	CheckRunning:
		Sleep 1000
		FindProcDLL::FindProc "${DEFAULTEXE}"                  
		StrCmp $R0 "1" CheckRunning
		Goto MoveBack
		
	MoveBack:
		Rename "$PROGRAMDIRECTORY\Settings.xml" "$SETTINGSDIRECTORY\Settings.xml"
		Delete "$PROGRAMDIRECTORY\Devices.xml"
		RMDir /r "$TEMP\${NAME}"

		StrCmp $KEY1 "-1" "" DeleteKey2
		${registry::DeleteKeyEmpty} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin\mounts v2" $R0
		Sleep 100
		${registry::DeleteKeyEmpty} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin\Program Options" $R0
		Sleep 100
		${registry::DeleteKeyEmpty} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin" $R0
		Sleep 100
		${registry::DeleteKeyEmpty} "HKEY_CURRENT_USER\Software\Cygnus Solutions" $R0
		Sleep 100
		Goto DeleteKey5

	DeleteKey2:
		StrCmp $KEY2 "-1" "" DeleteKey3
		${registry::DeleteKeyEmpty} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin\mounts v2" $R0
		Sleep 100
		${registry::DeleteKeyEmpty} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin\Program Options" $R0
		Sleep 100
		${registry::DeleteKeyEmpty} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin" $R0
		Sleep 100
		Goto DeleteKey5
	
	DeleteKey3:
		StrCmp $KEY3 "-1" "" DeleteKey4
		${registry::DeleteKeyEmpty} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin\mounts v2" $R0
		Sleep 100
	
	DeleteKey4:
		StrCmp $KEY4 "-1" "" DeleteKey5
		${registry::DeleteKeyEmpty} "HKEY_CURRENT_USER\Software\Cygnus Solutions\Cygwin\Program Options" $R0
		Sleep 100

	DeleteKey5:
		userInfo::getAccountType
		Pop $0
		StrCmp $0 "Admin" "" TheEnd
		StrCmp $KEY5 "-1" "" DeleteKey6
		${registry::DeleteKeyEmpty} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin\mounts v2" $R0
		Sleep 100
		${registry::DeleteKeyEmpty} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin\Program Options" $R0
		Sleep 100
		${registry::DeleteKeyEmpty} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin" $R0
		Sleep 100
		${registry::DeleteKeyEmpty} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions" $R0
		Sleep 100
		Goto TheEnd
	
	DeleteKey6:
		StrCmp $KEY6 "-1" "" DeleteKey7
		${registry::DeleteKeyEmpty} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin\mounts v2" $R0
		Sleep 100
		${registry::DeleteKeyEmpty} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin\Program Options" $R0
		Sleep 100
		${registry::DeleteKeyEmpty} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin" $R0
		Sleep 100
		Goto TheEnd
	
	DeleteKey7:
		StrCmp $KEY7 "-1" "" DeleteKey8
		${registry::DeleteKeyEmpty} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin\mounts v2" $R0
		Sleep 100
	
	DeleteKey8:
		StrCmp $KEY8 "-1" "" TheEnd
		${registry::DeleteKeyEmpty} "HKEY_LOCAL_MACHINE\Software\Cygnus Solutions\Cygwin\Program Options" $R0
		Sleep 100
		Goto TheEnd
	
	LaunchAndExit:
		Exec $EXECSTRING
	
	TheEnd:
		System::Free 0
		${xml::Unload}
		${registry::Unload}
		newadvsplash::stop /WAIT
SectionEnd