/*
 * Decompiled with CFR 0.152.
 */
package Harvester;

import Harvester.BytesResult;
import java.io.File;

public class TableRow {
    private File file;
    private String md5Hash;
    private String sha1Hash;
    private String fileType;
    private BytesResult hexBytes;

    public TableRow(File f, String md5, String sha1Hash, BytesResult hex, String type) {
        this.file = f;
        this.md5Hash = md5;
        this.sha1Hash = sha1Hash;
        this.hexBytes = hex;
        this.fileType = type;
    }

    public File getFile() {
        return this.file;
    }

    public String getMD5Hash() {
        return this.md5Hash;
    }

    public String getSha1Hash() {
        return this.sha1Hash;
    }

    public String getHexBytes() {
        return this.hexBytes.getByteString();
    }

    public String getFileType() {
        return this.fileType;
    }

    public int getNumUniqueBytes() {
        return this.hexBytes.getNumUniqueBytes();
    }

    public int getOffset() {
        return this.hexBytes.getOffset();
    }

    public int getNumBytes() {
        return this.hexBytes.getNumBytes();
    }

    public void setOffset(int offset) {
        this.hexBytes.setOffset(offset);
    }

    public void setNumBytes(int numBytes) {
        this.hexBytes.setNumBytes(numBytes);
    }

    public void setHexBytes(String newHexBytes) {
        this.hexBytes.setByteString(newHexBytes);
    }

    public void setHexBytesResult(BytesResult result) {
        this.hexBytes = result;
    }

    public String getByteString() {
        StringBuilder s = new StringBuilder();
        int offset = this.hexBytes.getOffset();
        int numBytes = this.hexBytes.getNumBytes();
        s.append(offset);
        s.append(" to ");
        s.append(offset + numBytes - 1);
        return s.toString();
    }
}

