/*
 * Decompiled with CFR 0.152.
 */
package Harvester;

import Harvester.CheckboxDialog;
import Harvester.DragAndDropHandler;
import Harvester.HyperlinkListener;
import Harvester.ImageFilter;
import Harvester.JPopupTextArea;
import Harvester.NumericalComparator;
import Harvester.PoliceAboutBox;
import Harvester.PoliceApp;
import Harvester.PoliceModel;
import Harvester.TableRenderer;
import Harvester.TextFilter;
import Harvester.VideoFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.layout.GroupLayout;

public class PoliceView
extends FrameView
implements ListSelectionListener {
    private JPopupTextArea Console;
    private JLabel MSPCCUIcon;
    private JButton add;
    private JLabel addressLine1;
    private JLabel addressLine2;
    private JPanel buttonPanel;
    private JButton delete;
    private JLabel dirigoStatePoliceLogo;
    private JTable displayTable;
    private JLabel faxLabel;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JLabel phoneLabel;
    private JProgressBar progressBar;
    private JButton save;
    private JButton saveAll;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private PoliceModel model;
    private JDialog options;
    private JPopupMenu popupMenu;
    private JPopupMenu popup;
    private JFileChooser loadFileChooser;
    private JFileChooser saveFileChooser;
    private Desktop desktop;
    private static final String DELETE_STRING = "deleteFiles";
    private static final String OPEN_STRING = "openFiles";
    private static final int INVALID = -1;

    public PoliceView(SingleFrameApplication app, PoliceModel model) {
        super(app);
        this.model = model;
        this.desktop = null;
        if (Desktop.isDesktopSupported()) {
            this.desktop = Desktop.getDesktop();
        }
        this.initComponents();
        this.popupMenu = new JPopupMenu();
        JMenuItem extractBytes = new JMenuItem("Extract different bytes");
        JMenuItem launchFile = new JMenuItem("Open file(s) in default program");
        TableRightClickListener rightClicker = new TableRightClickListener(this, model, this.displayTable);
        extractBytes.addActionListener(rightClicker);
        JMenuItem deleteRows = new JMenuItem("Delete selected row(s)");
        deleteRows.addActionListener(rightClicker);
        launchFile.addActionListener(rightClicker);
        this.popupMenu.add(extractBytes);
        this.popupMenu.add(launchFile);
        this.popupMenu.add(deleteRows);
        this.displayTable.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        JMenuItem cutMenuItem = new JMenuItem("Cut");
        cutMenuItem.addActionListener(actionListener);
        this.popup.add(cutMenuItem);
        JMenuItem copyMenuItem = new JMenuItem("Copy");
        copyMenuItem.addActionListener(actionListener);
        this.popup.add(copyMenuItem);
        JMenuItem pasteMenuItem = new JMenuItem("Paste");
        pasteMenuItem.addActionListener(actionListener);
        pasteMenuItem.setEnabled(false);
        this.popup.add(pasteMenuItem);
        if (this.desktop != null && this.desktop.isSupported(Desktop.Action.OPEN)) {
            this.displayTable.addMouseListener(new DoubleClickListener(this));
        } else {
            launchFile.setEnabled(false);
        }
        this.displayTable.getSelectionModel().addListSelectionListener(this);
        this.fixButtonStatuses();
        this.loadFileChooser = new JFileChooser();
        this.loadFileChooser.setFileFilter(new ImageFilter());
        this.loadFileChooser.setFileFilter(new VideoFilter());
        this.loadFileChooser.setMultiSelectionEnabled(true);
        this.loadFileChooser.setFileSelectionMode(2);
        this.saveFileChooser = new JFileChooser();
        this.saveFileChooser.setFileSelectionMode(0);
        this.saveFileChooser.setFileFilter(new TextFilter());
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PoliceView.this.busyIconIndex = (PoliceView.this.busyIconIndex + 1) % PoliceView.this.busyIcons.length;
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.progressBar.setVisible(true);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!PoliceView.this.busyIconTimer.isRunning()) {
                        PoliceView.this.busyIconIndex = 0;
                        PoliceView.this.busyIconTimer.start();
                    }
                    PoliceView.this.progressBar.setVisible(false);
                    PoliceView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    PoliceView.this.busyIconTimer.stop();
                    PoliceView.this.progressBar.setVisible(false);
                    PoliceView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    PoliceView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    PoliceView.this.progressBar.setVisible(true);
                    PoliceView.this.progressBar.setIndeterminate(false);
                    PoliceView.this.progressBar.setValue(value);
                }
            }
        });
        this.mainPanel.setTransferHandler(new DragAndDropHandler(model, this, this.displayTable));
        this.addTableShortcuts();
    }

    private void addTableShortcuts() {
        InputMap map = this.displayTable.getInputMap(1);
        map.put(KeyStroke.getKeyStroke(10, 0), OPEN_STRING);
        map.put(KeyStroke.getKeyStroke("control D"), DELETE_STRING);
        map.put(KeyStroke.getKeyStroke(127, 0), DELETE_STRING);
        map.put(KeyStroke.getKeyStroke(8, 0), DELETE_STRING);
        this.displayTable.getActionMap().put(OPEN_STRING, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PoliceView.this.openFiles();
            }
        });
        this.displayTable.getActionMap().put(DELETE_STRING, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PoliceView.this.deleteRows();
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = PoliceApp.getApplication().getMainFrame();
            this.aboutBox = new PoliceAboutBox((Frame)mainFrame, this.desktop);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        PoliceApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void showOptionsBox() {
        if (this.options == null) {
            JFrame mainFrame = PoliceApp.getApplication().getMainFrame();
            this.options.setLocationRelativeTo(mainFrame);
        }
        PoliceApp.getApplication().show(this.options);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.displayTable = new JTable();
        this.jPanel2 = new JPanel();
        this.MSPCCUIcon = new JLabel();
        this.jPanel3 = new JPanel();
        this.addressLine1 = new JLabel();
        this.addressLine2 = new JLabel();
        this.phoneLabel = new JLabel();
        this.faxLabel = new JLabel();
        this.dirigoStatePoliceLogo = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.statusLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.add = new JButton();
        this.delete = new JButton();
        this.save = new JButton();
        this.saveAll = new JButton();
        this.progressBar = new JProgressBar();
        this.jScrollPane2 = new JScrollPane();
        this.Console = new JPopupTextArea();
        this.mainPanel.setName("mainPanel");
        this.jScrollPane1.setName("jScrollPane1");
        this.displayTable.setModel(this.model);
        this.displayTable.setComponentPopupMenu(this.popupMenu);
        this.displayTable.setDragEnabled(true);
        this.displayTable.setName("displayTable");
        this.jScrollPane1.setViewportView(this.displayTable);
        this.displayTable.setDefaultRenderer(Object.class, new TableRenderer());
        TableRowSorter<PoliceModel> sorter = new TableRowSorter<PoliceModel>(this.model);
        sorter.setComparator(5, new NumericalComparator());
        this.displayTable.setRowSorter(sorter);
        this.displayTable.setFillsViewportHeight(true);
        this.displayTable.getTableHeader().addMouseListener(new ClickableListener());
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setLayout(new BorderLayout());
        this.MSPCCUIcon.setHorizontalAlignment(2);
        ResourceMap resourceMap = Application.getInstance(PoliceApp.class).getContext().getResourceMap(PoliceView.class);
        this.MSPCCUIcon.setIcon(resourceMap.getIcon("MSPCCUIcon.icon"));
        this.MSPCCUIcon.setText(resourceMap.getString("MSPCCUIcon.text", new Object[0]));
        this.MSPCCUIcon.setToolTipText(resourceMap.getString("MSPCCUIcon.toolTipText", new Object[0]));
        this.MSPCCUIcon.setName("MSPCCUIcon");
        this.jPanel2.add((Component)this.MSPCCUIcon, "Before");
        this.MSPCCUIcon.addMouseListener(new HyperlinkListener(this.desktop, "http://www.mcctf.org"));
        this.jPanel3.setName("jPanel3");
        this.addressLine1.setHorizontalAlignment(0);
        this.addressLine1.setText(resourceMap.getString("addressLine1.text", new Object[0]));
        this.addressLine1.setName("addressLine1");
        this.addressLine2.setHorizontalAlignment(0);
        this.addressLine2.setText(resourceMap.getString("addressLine2.text", new Object[0]));
        this.addressLine2.setName("addressLine2");
        this.phoneLabel.setHorizontalAlignment(0);
        this.phoneLabel.setText(resourceMap.getString("phoneLabel.text", new Object[0]));
        this.phoneLabel.setName("phoneLabel");
        this.faxLabel.setHorizontalAlignment(0);
        this.faxLabel.setText(resourceMap.getString("faxLabel.text", new Object[0]));
        this.faxLabel.setName("faxLabel");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.phoneLabel, -1, 289, Short.MAX_VALUE).add((Component)this.faxLabel, -1, 289, Short.MAX_VALUE).add((Component)this.addressLine2, -1, 289, Short.MAX_VALUE).add((Component)this.addressLine1, -1, 289, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap(25, Short.MAX_VALUE).add((Component)this.addressLine1).addPreferredGap(0).add((Component)this.addressLine2).addPreferredGap(0).add((Component)this.phoneLabel).addPreferredGap(0).add((Component)this.faxLabel).addContainerGap()));
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.dirigoStatePoliceLogo.setHorizontalAlignment(4);
        this.dirigoStatePoliceLogo.setIcon(resourceMap.getIcon("dirigoStatePoliceLogo.icon"));
        this.dirigoStatePoliceLogo.setToolTipText(resourceMap.getString("dirigoStatePoliceLogo.toolTipText", new Object[0]));
        this.dirigoStatePoliceLogo.setName("dirigoStatePoliceLogo");
        this.jPanel2.add((Component)this.dirigoStatePoliceLogo, "After");
        this.dirigoStatePoliceLogo.addMouseListener(new HyperlinkListener(this.desktop, "http://www.state.me.us/dps/msp/"));
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE).add(2, (Component)this.jPanel2, -1, 729, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 337, Short.MAX_VALUE)));
        this.mainPanel.addPropertyChangeListener("dropLocation", new TableRepainter());
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(PoliceApp.class).getContext().getActionMap(PoliceView.class, this);
        this.jMenuItem1.setAction(actionMap.get("launchFileChooser"));
        this.jMenuItem1.setName("jMenuItem1");
        fileMenu.add(this.jMenuItem1);
        this.jMenuItem2.setAction(actionMap.get("saveToDisk"));
        this.jMenuItem2.setName("jMenuItem2");
        fileMenu.add(this.jMenuItem2);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.jMenu1.setAction(actionMap.get("configureOffset"));
        this.jMenu1.setText(resourceMap.getString("jMenu1.text", new Object[0]));
        this.jMenu1.setName("jMenu1");
        this.jMenuItem3.setAction(actionMap.get("configureOffset"));
        this.jMenuItem3.setText(resourceMap.getString("jMenuItem3.text", new Object[0]));
        this.jMenuItem3.setName("jMenuItem3");
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuItem4.setAction(actionMap.get("configureNumBytes"));
        this.jMenuItem4.setText(resourceMap.getString("jMenuItem4.text", new Object[0]));
        this.jMenuItem4.setToolTipText(resourceMap.getString("jMenuItem4.toolTipText", new Object[0]));
        this.jMenuItem4.setName("jMenuItem4");
        this.jMenu1.add(this.jMenuItem4);
        this.jMenuItem5.setAction(actionMap.get("changeSavedColumns"));
        this.jMenuItem5.setText(resourceMap.getString("jMenuItem5.text", new Object[0]));
        this.jMenuItem5.setToolTipText(resourceMap.getString("jMenuItem5.toolTipText", new Object[0]));
        this.jMenuItem5.setName("jMenuItem5");
        this.jMenu1.add(this.jMenuItem5);
        this.menuBar.add(this.jMenu1);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setToolTipText(resourceMap.getString("aboutMenuItem.toolTipText", new Object[0]));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new BorderLayout());
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setText(resourceMap.getString("statusLabel.text", new Object[0]));
        this.statusLabel.setName("statusLabel");
        this.jPanel1.add((Component)this.statusLabel, "First");
        this.buttonPanel.setName("buttonPanel");
        this.buttonPanel.setLayout(new BorderLayout());
        this.jPanel5.setName("jPanel5");
        this.add.setAction(actionMap.get("addOrCancel"));
        this.add.setName("add");
        this.jPanel5.add(this.add);
        this.delete.setAction(actionMap.get("deleteRows"));
        this.delete.setText(resourceMap.getString("delete.text", new Object[0]));
        this.delete.setName("delete");
        this.jPanel5.add(this.delete);
        this.save.setAction(actionMap.get("saveToDisk"));
        this.save.setText(resourceMap.getString("save.text", new Object[0]));
        this.save.setName("save");
        this.jPanel5.add(this.save);
        this.saveAll.setAction(actionMap.get("saveAllToDisk"));
        this.saveAll.setText(resourceMap.getString("saveAll.text", new Object[0]));
        this.saveAll.setName("saveAll");
        this.jPanel5.add(this.saveAll);
        this.buttonPanel.add((Component)this.jPanel5, "Center");
        this.jPanel1.add((Component)this.buttonPanel, "Last");
        this.progressBar.setName("progressBar");
        this.progressBar.setStringPainted(true);
        this.jPanel1.add((Component)this.progressBar, "Center");
        this.progressBar.setVisible(false);
        this.jScrollPane2.setName("jScrollPane2");
        this.Console.setColumns(20);
        this.Console.setRows(5);
        this.Console.setName("Console");
        this.jScrollPane2.setViewportView(this.Console);
        GroupLayout statusPanelLayout = new GroupLayout((Container)this.statusPanel);
        this.statusPanel.setLayout((LayoutManager)statusPanelLayout);
        statusPanelLayout.setHorizontalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)statusPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)statusPanelLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane2, -1, 729, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, 729, Short.MAX_VALUE)).addContainerGap()));
        statusPanelLayout.setVerticalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 109, Short.MAX_VALUE).addContainerGap()));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.fixButtonStatuses();
        this.displayTable.requestFocus();
    }

    @Action
    public void changeSettings() {
    }

    @Action
    public void addOrCancel() {
        if (this.model.isAddingFiles()) {
            this.cancelAddingFiles();
        } else {
            this.launchFileChooser();
        }
    }

    @Action
    public void launchFileChooser() {
        JFrame mainFrame = PoliceApp.getApplication().getMainFrame();
        int result = this.loadFileChooser.showDialog(mainFrame, "Add");
        if (result == 1) {
            this.setStatusText("Canceled save");
            return;
        }
        File[] files = this.loadFileChooser.getSelectedFiles();
        this.model.addFiles(files, this.loadFileChooser.getFileFilter());
    }

    @Action
    public void cancelAddingFiles() {
        this.model.cancelBackgroundTask();
    }

    public File getSaveFile() {
        JFrame mainFrame = PoliceApp.getApplication().getMainFrame();
        File defaultSave = new File("output.txt");
        this.saveFileChooser.setSelectedFile(defaultSave);
        int result = this.saveFileChooser.showSaveDialog(mainFrame);
        if (result == 1) {
            this.setStatusText("Canceled save");
            return null;
        }
        File output = this.saveFileChooser.getSelectedFile();
        if (output.exists()) {
            int selection = JOptionPane.showConfirmDialog(mainFrame, "File exists, do you wish to overwrite?", "Confirm save", 1, 2);
            if (selection == 2) {
                this.setStatusText("Canceled save");
                return null;
            }
            if (selection == 0) {
                return output;
            }
            if (selection == 1) {
                return this.getSaveFile();
            }
        }
        return output;
    }

    @Action
    public void saveToDisk() {
        File output = this.getSaveFile();
        if (output == null) {
            return;
        }
        int[] selections = this.displayTable.getSelectedRows();
        for (int i = 0; i < selections.length; ++i) {
            selections[i] = this.displayTable.convertRowIndexToModel(selections[i]);
        }
        this.model.save(output, selections);
        this.fixButtonStatuses();
    }

    @Action
    public void saveAllToDisk() {
        File output = this.getSaveFile();
        if (output == null) {
            return;
        }
        int[] selections = new int[this.displayTable.getRowCount()];
        for (int i = 0; i < selections.length; ++i) {
            selections[i] = this.displayTable.convertRowIndexToModel(i);
        }
        this.model.save(output, selections);
        this.fixButtonStatuses();
    }

    public void logError(String s) {
        this.Console.append(s);
    }

    public void setStatusText(String s) {
        this.statusLabel.setText(s);
    }

    public void fixButtonStatuses() {
        if (this.model.isAddingFiles()) {
            this.add.setText("Stop Adding Files");
            this.add.setToolTipText("Stop adding the current batch of files");
        } else {
            this.add.setText("Add Files");
            this.add.setToolTipText("Choose files to hash");
        }
        this.saveAll.setEnabled(this.model.canSave());
        this.save.setEnabled(this.displayTable.getSelectedRowCount() > 0);
        this.delete.setEnabled(this.displayTable.getSelectedRowCount() > 0);
    }

    @Action
    public void openFiles() {
        int[] selections = this.displayTable.getSelectedRows();
        for (int i = 0; i < selections.length; ++i) {
            selections[i] = this.displayTable.convertRowIndexToModel(selections[i]);
        }
        this.model.openFiles(this.desktop, selections);
    }

    @Action
    public void deleteRows() {
        int[] selections = this.displayTable.getSelectedRows();
        for (int i = 0; i < selections.length; ++i) {
            selections[i] = this.displayTable.convertRowIndexToModel(selections[i]);
        }
        this.model.removeRows(selections);
        this.fixButtonStatuses();
    }

    @Action
    public void changeSavedColumns() {
        CheckboxDialog dialog = new CheckboxDialog(PoliceApp.getApplication().getMainFrame(), "Which columns do you want written to file?", PoliceModel.COLUMN_HEADERS, this.model.getColumnsToSave());
        dialog.select();
        this.model.setColumnsToSave(dialog.getSelections());
        dialog = null;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public JLabel getProgressLabel() {
        return this.statusLabel;
    }

    public JFileChooser getLoadFileChooser() {
        return this.loadFileChooser;
    }

    @Action
    public void emailNick() {
        this.email("ndunn2@bowdoin.edu");
    }

    @Action
    public void emailTucker() {
    }

    @Action
    public void emailJeremy() {
    }

    @Action
    public void email(String address) {
    }

    @Action
    public void launchBrowser(String url) {
        if (this.desktop != null && this.desktop.isSupported(Desktop.Action.BROWSE)) {
            URI uri = null;
            try {
                uri = new URI(url);
                this.desktop.browse(uri);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.logError(ioe.getLocalizedMessage());
            }
            catch (URISyntaxException use) {
                use.printStackTrace();
                this.logError(use.getLocalizedMessage());
            }
        }
    }

    public void extractNewBytes() {
        JFrame mainFrame = PoliceApp.getApplication().getMainFrame();
        String s = (String)JOptionPane.showInputDialog(mainFrame, "Enter byte offset:", "Edit byte offset", -1, null, null, "" + this.model.getOffset());
        int offset = -1;
        if (s != null && s.length() > 0) {
            try {
                offset = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                this.setStatusText("Error: " + s + " is not a number.");
                return;
            }
        }
        int numBytes = -1;
        s = (String)JOptionPane.showInputDialog(mainFrame, "Enter number of bytes to extract:", "Edit number of bytes", -1, null, null, "" + this.model.getNumBytes());
        if (s != null && s.length() > 0) {
            try {
                numBytes = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                this.setStatusText("Error: " + s + " is not a number.");
                return;
            }
        }
        if (offset != -1 && numBytes != -1) {
            int[] selections = this.displayTable.getSelectedRows();
            for (int i = 0; i < selections.length; ++i) {
                selections[i] = this.displayTable.convertRowIndexToModel(selections[i]);
            }
            this.setStatusText("Editing the offsets of " + selections.length + " files.");
            this.model.editOffsets(selections, offset, numBytes);
        }
    }

    @Action
    public void configureOffset() {
        JFrame mainFrame = PoliceApp.getApplication().getMainFrame();
        String s = (String)JOptionPane.showInputDialog(mainFrame, "Enter byte offset:", "Edit byte offset", -1, null, null, "" + this.model.getOffset());
        if (s != null && s.length() > 0) {
            try {
                int offset = Integer.parseInt(s);
                this.model.setOffset(offset);
            }
            catch (NumberFormatException e) {
                this.setStatusText("Error: " + s + " is not a number.");
            }
            return;
        }
        this.setStatusText("Cancelled editing byte offset");
    }

    @Action
    public void configureNumBytes() {
        JFrame mainFrame = PoliceApp.getApplication().getMainFrame();
        String s = (String)JOptionPane.showInputDialog(mainFrame, "Enter number of bytes to extract:", "Edit number of bytes", -1, null, null, "" + this.model.getNumBytes());
        if (s != null && s.length() > 0) {
            try {
                int offset = Integer.parseInt(s);
                this.model.setNumBytes(offset);
            }
            catch (NumberFormatException e) {
                this.setStatusText("Error: " + s + " is not a number.");
            }
            return;
        }
        this.setStatusText("Cancelled editing number of bytes");
    }

    class TableRightClickListener
    implements ActionListener {
        private PoliceView view;
        private PoliceModel model;
        private JTable table;
        public static final String EXTRACT_STRING = "Extract different bytes";
        public static final String DELETE_STRING = "Delete selected row(s)";
        public static final String LAUNCH_STRING = "Open file(s) in default program";

        public TableRightClickListener(PoliceView view, PoliceModel model, JTable table) {
            this.view = view;
            this.model = model;
            this.table = table;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(EXTRACT_STRING)) {
                this.view.extractNewBytes();
            } else if (e.getActionCommand().equals(DELETE_STRING)) {
                this.view.deleteRows();
            } else if (e.getActionCommand().equals(LAUNCH_STRING)) {
                this.view.openFiles();
            }
        }
    }

    class TableRepainter
    implements PropertyChangeListener {
        TableRepainter() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getNewValue() == null) {
                ((Component)pce.getSource()).setBackground(null);
            }
        }
    }

    class DoubleClickListener
    extends MouseAdapter {
        public PoliceView view;

        public DoubleClickListener(PoliceView view) {
            this.view = view;
        }

        public void mousePressed(MouseEvent e) {
            if (!e.isPopupTrigger() && e.getClickCount() == 2) {
                this.view.openFiles();
            }
        }
    }

    class ClickableListener
    extends MouseAdapter {
        ClickableListener() {
        }

        public void mouseEntered(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent e) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PoliceView.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

