/*
 * Decompiled with CFR 0.152.
 */
package Harvester;

import Harvester.BackgroundWorker;
import Harvester.BytesResult;
import Harvester.FileHashConverter;
import Harvester.HashRequest;
import Harvester.ImageFilter;
import Harvester.PoliceView;
import Harvester.TableRow;
import Harvester.Utility;
import Harvester.VideoFilter;
import java.awt.Desktop;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoliceModel
extends AbstractTableModel {
    public static final boolean DEBUG = true;
    private Preferences prefs;
    private String department;
    private String name;
    private PoliceView view;
    private List<TableRow> data;
    private final HashRequest MD5 = new HashRequest("MD5", 16);
    private final HashRequest SHA_1 = new HashRequest("SHA-1", 32);
    private List<HashRequest> hashTypes;
    private SwingWorker backgroundTask;
    private FileFilter videoFilter = new VideoFilter();
    private FileFilter imageFilter = new ImageFilter();
    public static final int NUM_COLS = 7;
    public static final int FILES_INDEX = 0;
    public static final int MD5_INDEX = 1;
    public static final int SHA_1_INDEX = 2;
    public static final int BYTES_EXTRACTED_INDEX = 3;
    public static final int HEX_BYTES_INDEX = 4;
    public static final int NUM_UNIQUE_BYTES_INDEX = 5;
    public static final int FILE_TYPE_INDEX = 6;
    public static final String DEFAULT_OUTPUT_NAME = "output.txt";
    public static final String FILES_STRING = "File Name";
    public static final String MD5_STRING = "MD5 Hash (Base 16)";
    public static final String SHA_1_STRING = "SHA-1 Hash (Base 32)";
    public static final String BYTES_EXTRACTED_STRING = "Which bytes extracted";
    public static final String HEX_BYTES_STRING = "Hex byte string";
    public static final String NUM_UNIQUE_BYTES_STRING = "Number of unique bytes";
    public static final String FILE_TYPE_STRING = "File Type";
    public static final String IMAGE_STRING = "Image";
    public static final String VIDEO_STRING = "Video";
    public static final String UNKNOWN_STRING = "Unknown";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String COLUMN_SEPARATOR = ",";
    public static final String[] COLUMN_HEADERS = new String[]{"File Name", "MD5 Hash (Base 16)", "SHA-1 Hash (Base 32)", "Which bytes extracted", "Hex byte string", "Number of unique bytes", "File Type"};
    public static final int DEFAULT_NUM_BYTES = 10;
    public static final int DEFAULT_BYTE_OFFSET = 43000;
    public static final String DEFAULT_NUM_BYTES_STRING = "defaultNumBytes";
    public static final String DEFAULT_BYTE_OFFSET_STRING = "defaultByteOffset";
    private int numBytes;
    private int offset;
    private boolean[] columnsToSave;
    public static final String DEFAULT_COLUMNS_TO_SAVE_KEY = "defaultColumns";
    public static final String DEFAULT_COLUMNS_TO_SAVE_VALUE = "1111100";

    public PoliceModel() {
        this.hashTypes = new LinkedList<HashRequest>();
        this.hashTypes.add(this.MD5);
        this.hashTypes.add(this.SHA_1);
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.numBytes = this.prefs.getInt(DEFAULT_NUM_BYTES_STRING, 10);
        this.offset = this.prefs.getInt(DEFAULT_BYTE_OFFSET_STRING, 43000);
        this.data = new ArrayList<TableRow>();
        String colsToSaveBitString = this.prefs.get(DEFAULT_COLUMNS_TO_SAVE_KEY, DEFAULT_COLUMNS_TO_SAVE_VALUE);
        this.columnsToSave = Utility.fromBitString(colsToSaveBitString);
    }

    public boolean[] getColumnsToSave() {
        return this.columnsToSave;
    }

    public void setColumnsToSave(boolean[] columnsToSave) {
        this.columnsToSave = columnsToSave;
        this.prefs.put(DEFAULT_COLUMNS_TO_SAVE_KEY, Utility.toBitString(columnsToSave));
    }

    public void setView(PoliceView view) {
        this.view = view;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            this.view.setStatusText("Error, offset must be positive");
            return;
        }
        this.view.setStatusText("Changing offset from " + this.offset + " to " + offset);
        this.offset = offset;
        this.prefs.putInt(DEFAULT_BYTE_OFFSET_STRING, offset);
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public void setNumBytes(int numBytes) {
        if (numBytes < 0) {
            this.view.setStatusText("Error, number of bytes must be positive");
            return;
        }
        this.view.setStatusText("Changing number of bytes from " + this.numBytes + " to " + numBytes);
        this.numBytes = numBytes;
        this.prefs.putInt(DEFAULT_NUM_BYTES_STRING, numBytes);
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public boolean canSave() {
        return this.data.size() > 0;
    }

    public static boolean isUniqueEnough(int numUniqueBytes) {
        return numUniqueBytes > 3;
    }

    public boolean isUnique(int row) {
        return PoliceModel.isUniqueEnough(this.data.get(row).getNumUniqueBytes());
    }

    public void editOffsets(int[] modelRows, int newOffset, int newNumBytes) {
        if (newNumBytes < 0) {
            this.view.setStatusText("Error, number of bytes must be positive");
            return;
        }
        if (newOffset < 0) {
            this.view.setStatusText("Error, offset must be positive");
            return;
        }
        for (int row : modelRows) {
            TableRow curRow = this.data.get(row);
            File f = curRow.getFile();
            try {
                BytesResult result = FileHashConverter.getFileByteHex(newOffset, newNumBytes, f);
                curRow.setHexBytesResult(result);
            }
            catch (FileNotFoundException e) {
                this.view.logError("Error, could not find file " + f.getName());
            }
            catch (IOException e) {
                this.view.logError("Error, failed to open file " + f.getName());
            }
        }
        this.fireTableDataChanged();
    }

    public List<File> flattenDirectoryTree(File[] files, javax.swing.filechooser.FileFilter filter) {
        LinkedList<File> fileList = new LinkedList<File>();
        for (File f : files) {
            this.addFile(f, fileList, filter);
        }
        return fileList;
    }

    public void addFile(File f, List<File> fileList, javax.swing.filechooser.FileFilter filter) {
        if (!f.exists() || !filter.accept(f)) {
            return;
        }
        if (f.isDirectory()) {
            this.addDirectory(f, fileList, filter);
        } else {
            if (!FileHashConverter.canExtractBytes(f, this.offset, this.numBytes)) {
                this.view.logError("File " + f + " is too small for processing; " + "ignoring" + LINE_SEPARATOR);
                return;
            }
            fileList.add(f);
        }
    }

    public void addDirectory(File dir, List<File> fileList, javax.swing.filechooser.FileFilter filter) {
        for (File f : dir.listFiles()) {
            this.addFile(f, fileList, filter);
        }
    }

    public void addRows(List<TableRow> rows) {
        int startIndex = this.data.size();
        this.data.addAll(rows);
        int endIndex = this.data.size() - 1;
        this.fireTableRowsInserted(startIndex, endIndex);
    }

    public String getFileType(File f) {
        if (this.imageFilter.accept(f)) {
            return IMAGE_STRING;
        }
        if (this.videoFilter.accept(f)) {
            return VIDEO_STRING;
        }
        return UNKNOWN_STRING;
    }

    public void addFiles(Collection<File> files) {
        this.addFiles(files, this.view.getLoadFileChooser().getAcceptAllFileFilter());
    }

    public void addFiles(Collection<File> files, javax.swing.filechooser.FileFilter filter) {
        File[] fileArray = (File[])files.toArray();
        this.addFiles(fileArray, filter);
    }

    public void addFiles(File[] array, javax.swing.filechooser.FileFilter filter) {
        List<File> flattenedFiles = this.flattenDirectoryTree(array, filter);
        this.backgroundTask = new BackgroundWorker(flattenedFiles, this.hashTypes, this, this.view, this.offset, this.numBytes);
        this.backgroundTask.execute();
        this.view.getProgressLabel().setText("Adding " + flattenedFiles.size() + " files.");
        final JProgressBar progressBar = this.view.getProgressBar();
        progressBar.setVisible(true);
        this.backgroundTask.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("progress")) {
                    progressBar.setValue((Integer)evt.getNewValue());
                }
            }
        });
        this.view.fixButtonStatuses();
    }

    public void cancelBackgroundTask() {
        if (this.backgroundTask != null) {
            this.backgroundTask.cancel(true);
        }
    }

    public boolean isAddingFiles() {
        return this.backgroundTask != null && !this.backgroundTask.isDone();
    }

    public void openFiles(Desktop desktop, int[] rows) {
        for (int row : rows) {
            try {
                desktop.open(this.data.get(row).getFile());
            }
            catch (IOException ex) {
                Logger.getLogger(PoliceModel.class.getName()).log(Level.SEVERE, null, ex);
                this.view.logError(ex.getLocalizedMessage());
            }
        }
    }

    public void removeRows(int[] rows) {
        Arrays.sort(rows);
        for (int i = rows.length - 1; i > -1; --i) {
            this.removeRow(rows[i]);
        }
        this.view.setStatusText("Deleted " + rows.length + " records");
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        this.data.remove(row);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_HEADERS[columnIndex];
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.data.get(row).getFile().getName();
            }
            case 1: {
                return this.data.get(row).getMD5Hash();
            }
            case 2: {
                return this.data.get(row).getSha1Hash();
            }
            case 4: {
                return this.data.get(row).getHexBytes();
            }
            case 3: {
                return this.data.get(row).getByteString();
            }
            case 5: {
                return this.data.get(row).getNumUniqueBytes();
            }
            case 6: {
                return this.data.get(row).getFileType();
            }
        }
        return "Error in PoliceModel::getValueAt()";
    }

    public void save(File output, int[] selections) {
        int numColsToSave = 0;
        for (boolean b : this.columnsToSave) {
            if (!b) continue;
            ++numColsToSave;
        }
        try {
            BufferedWriter outputStream = new BufferedWriter(new FileWriter(output));
            int colsWritten = 0;
            for (int i = 0; i < 7; ++i) {
                if (!this.columnsToSave[i]) continue;
                outputStream.write(COLUMN_HEADERS[i]);
                if (++colsWritten >= numColsToSave) continue;
                outputStream.write(COLUMN_SEPARATOR);
            }
            outputStream.write(LINE_SEPARATOR);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < selections.length; ++i) {
                builder.setLength(0);
                int index = selections[i];
                colsWritten = 0;
                for (int j = 0; j < 7; ++j) {
                    if (!this.columnsToSave[j]) continue;
                    builder.append(this.getValueAt(index, j));
                    if (++colsWritten >= numColsToSave) continue;
                    builder.append(COLUMN_SEPARATOR);
                }
                builder.append(LINE_SEPARATOR);
                outputStream.write(builder.toString());
            }
            outputStream.close();
            this.view.setStatusText("Successfully wrote " + selections.length + " records to " + output);
        }
        catch (IOException e) {
            this.view.logError("Could not open file " + output + " for writing." + LINE_SEPARATOR);
            return;
        }
    }
}

