/*
 * Decompiled with CFR 0.152.
 */
package Harvester;

import Harvester.Base32;
import Harvester.BytesResult;
import Harvester.HashRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHashConverter {
    private static final int BUFFER_SIZE = (int)Math.pow(2.0, 25.0);
    public static final int NUM_BYTES_POSSIBLE = (int)Math.pow(2.0, 8.0);

    public static List<String> getFileHashes(File input, List<HashRequest> hashingRequests) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        if (input.length() == 0L) {
            throw new IOException("Error, file " + input + " has 0 bytes");
        }
        LinkedList<String> hashes = new LinkedList<String>();
        byte[] buffer = new byte[Math.min(BUFFER_SIZE, (int)input.length())];
        int read = 0;
        FileInputStream fis = new FileInputStream(input);
        LinkedList<MessageDigest> algorithms = new LinkedList<MessageDigest>();
        for (HashRequest h : hashingRequests) {
            MessageDigest algorithm = MessageDigest.getInstance(h.getName());
            algorithm.reset();
            algorithms.add(algorithm);
        }
        while ((read = fis.read(buffer)) != -1) {
            for (MessageDigest algorithm : algorithms) {
                algorithm.update(buffer, 0, read);
            }
        }
        for (int i = 0; i < algorithms.size(); ++i) {
            MessageDigest algorithm;
            algorithm = (MessageDigest)algorithms.get(i);
            HashRequest request = hashingRequests.get(i);
            byte[] messageDigest = algorithm.digest();
            hashes.add(FileHashConverter.getStringFromBytes(messageDigest, request.getRadix()));
        }
        return hashes;
    }

    public static String getStringFromBytes(byte[] bytes, int base) {
        switch (base) {
            case 32: {
                return Base32.encode(bytes);
            }
            case 16: {
                StringBuffer hexString = new StringBuffer();
                for (int i = 0; i < bytes.length; ++i) {
                    String hexStr = Integer.toHexString(0xFF & bytes[i]);
                    if (hexStr.length() == 1) {
                        hexString.append('0');
                    }
                    hexString.append(hexStr);
                }
                return hexString.toString();
            }
        }
        return "Unsupported radix in getStringFromBytes.";
    }

    public static boolean canExtractBytes(File f, int offset, int numBytes) {
        return f.length() > 0L;
    }

    public static BytesResult getFileByteHex(int start, int numBytes, File input) throws FileNotFoundException, IOException {
        if (input.length() < (long)(start + numBytes - 1)) {
            return new BytesResult(start, numBytes, 0, "Not enough bytes for this offset");
        }
        byte[] fileBytes = new byte[numBytes];
        FileInputStream fis = new FileInputStream(input);
        fis.skip(start);
        fis.read(fileBytes, 0, numBytes);
        int numUniqueBytes = FileHashConverter.countUniqueBytes(fileBytes);
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < numBytes; ++i) {
            hexString.append("\\x");
            String hexStr = Integer.toHexString(0xFF & fileBytes[i]).toUpperCase();
            if (hexStr.length() == 1) {
                hexString.append('0');
                hexString.append(hexStr);
                continue;
            }
            hexString.append(hexStr);
        }
        return new BytesResult(start, numBytes, numUniqueBytes, hexString.toString());
    }

    public static int countUniqueBytes(byte[] bytes) {
        int[] counts = new int[NUM_BYTES_POSSIBLE];
        int numUnique = 0;
        for (byte b : bytes) {
            int index = 0xFF & b;
            if (counts[index] == 0) {
                ++numUnique;
            }
            int n = index;
            counts[n] = counts[n] + 1;
        }
        return numUnique;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BASE_FORMAT {
        BASE_32,
        BASE_16,
        BASE_10,
        BASE_8;

    }
}

