/*
 * Decompiled with CFR 0.152.
 */
package Harvester;

import Harvester.PoliceModel;
import Harvester.PoliceView;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class DragAndDropHandler
extends TransferHandler {
    private PoliceModel model;
    private PoliceView view;
    private JTable table;

    public DragAndDropHandler(PoliceModel model, PoliceView view, JTable table) {
        this.model = model;
        this.view = view;
        this.table = table;
    }

    public boolean canImport(TransferHandler.TransferSupport data) {
        return data.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    public boolean importData(TransferHandler.TransferSupport data) {
        if (!this.canImport(data)) {
            return false;
        }
        Transferable t = data.getTransferable();
        try {
            List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            this.model.addFiles(files);
        }
        catch (UnsupportedFlavorException ex) {
            Logger.getLogger(DragAndDropHandler.class.getName()).log(Level.SEVERE, null, ex);
            this.view.logError(ex.getMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(DragAndDropHandler.class.getName()).log(Level.SEVERE, null, ex);
            this.view.logError(ex.getMessage());
        }
        return true;
    }
}

