/*
 * Decompiled with CFR 0.152.
 */
package Harvester;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class CheckboxDialog
implements ItemListener {
    private final String[] choices;
    private boolean[] selections;
    private JCheckBox[] checkBoxes;
    private final String title;
    private Component parent;
    private static final int NUM_COLS = 2;

    public CheckboxDialog(Component parent, String title, String[] choices, boolean[] selections) {
        if (choices.length != selections.length) {
            throw new IllegalArgumentException("Error, choices and selections arrays must be of same length");
        }
        this.parent = parent;
        this.title = title;
        this.choices = choices;
        this.selections = selections;
        this.checkBoxes = new JCheckBox[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            this.checkBoxes[i] = new JCheckBox(choices[i], selections[i]);
            this.checkBoxes[i].addItemListener(this);
        }
    }

    public CheckboxDialog(String title, String[] choices, boolean[] selections) {
        this(null, title, choices, selections);
    }

    public CheckboxDialog(String title, String[] choices) {
        this(null, title, choices, new boolean[choices.length]);
    }

    public void select() {
        int numRows = (int)Math.ceil((double)this.checkBoxes.length / 2.0);
        JPanel panel = new JPanel(new GridLayout(numRows, 2));
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            panel.add(this.checkBoxes[i]);
        }
        JOptionPane optionPane = new JOptionPane(panel, 3);
        JDialog dialog = optionPane.createDialog(this.parent, this.title);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public boolean[] getSelections() {
        return this.selections;
    }

    public void itemStateChanged(ItemEvent evt) {
        ItemSelectable src = evt.getItemSelectable();
        for (int i = 0; i < this.selections.length; ++i) {
            if (this.checkBoxes[i] != src) continue;
            this.selections[i] = evt.getStateChange() == 1;
        }
    }
}

