/*
 * Decompiled with CFR 0.152.
 */
package Harvester;

import Harvester.BytesResult;
import Harvester.FileHashConverter;
import Harvester.HashRequest;
import Harvester.PoliceApp;
import Harvester.PoliceModel;
import Harvester.PoliceView;
import Harvester.TableRow;
import java.awt.Cursor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundWorker
extends SwingWorker<List<TableRow>, TableRow> {
    private List<File> files;
    private List<HashRequest> hashAlgorithms;
    private PoliceModel model;
    private PoliceView view;
    private int offset;
    private int numBytes;

    public BackgroundWorker(List<File> files, List<HashRequest> hashAlgorithms, PoliceModel model, PoliceView view, int offset, int numBytes) {
        this.files = files;
        this.hashAlgorithms = hashAlgorithms;
        this.model = model;
        this.view = view;
        this.offset = offset;
        this.numBytes = numBytes;
    }

    @Override
    protected List<TableRow> doInBackground() throws Exception {
        JFrame mainFrame = PoliceApp.getApplication().getMainFrame();
        mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        ArrayList<TableRow> results = new ArrayList<TableRow>();
        for (File f : this.files) {
            if (this.isCancelled() || Thread.interrupted()) {
                return results;
            }
            List<String> hashes = FileHashConverter.getFileHashes(f, this.hashAlgorithms);
            BytesResult hexBytes = FileHashConverter.getFileByteHex(this.offset, this.numBytes, f);
            String fileType = this.model.getFileType(f);
            TableRow current = new TableRow(f, hashes.get(0), hashes.get(1), hexBytes, fileType);
            results.add(current);
            this.publish(current);
            this.setProgress(100 * results.size() / this.files.size());
        }
        return results;
    }

    @Override
    protected void process(List<TableRow> chunks) {
        this.model.addRows(chunks);
    }

    @Override
    protected void done() {
        JFrame mainFrame = PoliceApp.getApplication().getMainFrame();
        mainFrame.setCursor(Cursor.getDefaultCursor());
        JProgressBar bar = this.view.getProgressBar();
        bar.setValue(0);
        bar.setVisible(false);
        this.view.fixButtonStatuses();
        if (this.isCancelled()) {
            this.view.setStatusText("Cancelled adding files");
        } else {
            try {
                int numFiles = ((List)this.get()).size();
                String file = numFiles > 1 ? "files" : "file";
                this.view.setStatusText("Successfully added " + numFiles + " " + file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

